﻿using Microsoft.AspNetCore.Identity;
using PowerAccounting.Areas.Identity.Data;
using PowerAccounting.MyModels;
using System.Collections.Generic;
using System.Threading.Tasks;
using Webgentle.BookStore.Models;

namespace Webgentle.BookStore.Repository
{
    public interface IAccountRepository
    {
        Task<PowerAccountingUser> GetUserByIdAsync(string id);
        Task<PowerAccountingUser> GetUserByEmailAsync(string email);
        Task<IdentityResult> DeleteUserByEmailAsync(string email);
        Task<IdentityResult> SetRoleToUserByMyRoleModelAsync(MyRoleModel roleModel);
        Task<IdentityResult> CreateUserAsync(SignUpUserModel userModel, bool Flag);

        Task<SignInResult> PasswordSignInAsync(SignInModel signInModel);

        Task SignOutAsync();
        Task<List<IdentityResult>> SetingsRoles();
        Task<IList<string>> GetAllUserRoleAsync(PowerAccountingUser email);
        Task<List<IdentityResult>> DeleteAllRoleAsync(string email);
        Task<IdentityResult> ChangePasswordAsync(ChangePasswordModel model);

        Task<IdentityResult> ConfirmEmailAsync(string uid, string token);

        Task GenerateEmailConfirmationTokenAsync(PowerAccountingUser user);

        Task GenerateForgotPasswordTokenAsync(PowerAccountingUser user);

        Task<IdentityResult> ResetPasswordAsync(ResetPasswordModel model);
    }
}