﻿using System;
using System.Collections.Generic;
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Metadata;

namespace PowerAccounting.Models2
{
    public partial class db_a63a88_iprotechContext : DbContext
    {
        public db_a63a88_iprotechContext()
        {
        }

        public db_a63a88_iprotechContext(DbContextOptions<db_a63a88_iprotechContext> options)
            : base(options)
        {
        }

        public virtual DbSet<Account> Accounts { get; set; } = null!;
        public virtual DbSet<Activity> Activities { get; set; } = null!;
        public virtual DbSet<AspNetRole> AspNetRoles { get; set; } = null!;
        public virtual DbSet<AspNetRoleClaim> AspNetRoleClaims { get; set; } = null!;
        public virtual DbSet<AspNetUser> AspNetUsers { get; set; } = null!;
        public virtual DbSet<AspNetUserClaim> AspNetUserClaims { get; set; } = null!;
        public virtual DbSet<AspNetUserLogin> AspNetUserLogins { get; set; } = null!;
        public virtual DbSet<AspNetUserToken> AspNetUserTokens { get; set; } = null!;
        public virtual DbSet<AuthorRight> AuthorRights { get; set; } = null!;
        public virtual DbSet<BusinessSecret> BusinessSecrets { get; set; } = null!;
        public virtual DbSet<Card> Cards { get; set; } = null!;
        public virtual DbSet<Class> Classes { get; set; } = null!;
        public virtual DbSet<Classification> Classifications { get; set; } = null!;
        public virtual DbSet<Consal> Consals { get; set; } = null!;
        public virtual DbSet<ConsalConsaltant> ConsalConsaltants { get; set; } = null!;
        public virtual DbSet<Consaltant> Consaltants { get; set; } = null!;
        public virtual DbSet<ConsaltantOrder> ConsaltantOrders { get; set; } = null!;
        public virtual DbSet<ConsaltantsRating> ConsaltantsRatings { get; set; } = null!;
        public virtual DbSet<ContactU> ContactUs { get; set; } = null!;
        public virtual DbSet<Department> Departments { get; set; } = null!;
        public virtual DbSet<GovernmentsFee> GovernmentsFees { get; set; } = null!;
        public virtual DbSet<Invention> Inventions { get; set; } = null!;
        public virtual DbSet<MarkRegister> MarkRegisters { get; set; } = null!;
        public virtual DbSet<Model> Models { get; set; } = null!;
        public virtual DbSet<ModelsQuestion> ModelsQuestions { get; set; } = null!;
        public virtual DbSet<MyContent> MyContents { get; set; } = null!;
        public virtual DbSet<MyCustomer> MyCustomers { get; set; } = null!;
        public virtual DbSet<MyStore> MyStores { get; set; } = null!;
        public virtual DbSet<MyType> MyTypes { get; set; } = null!;
        public virtual DbSet<News> News { get; set; } = null!;
        public virtual DbSet<Order> Orders { get; set; } = null!;
        public virtual DbSet<OrderComplation> OrderComplations { get; set; } = null!;
        public virtual DbSet<OrdersFile> OrdersFiles { get; set; } = null!;
        public virtual DbSet<OrdersModel> OrdersModels { get; set; } = null!;
        public virtual DbSet<Platform> Platforms { get; set; } = null!;
        public virtual DbSet<PricingOreder> PricingOreders { get; set; } = null!;
        public virtual DbSet<Proc> Procs { get; set; } = null!;
        public virtual DbSet<RegisterInvention> RegisterInventions { get; set; } = null!;
        public virtual DbSet<Relation> Relations { get; set; } = null!;
        public virtual DbSet<Reserve> Reserves { get; set; } = null!;
        public virtual DbSet<SecretRegister> SecretRegisters { get; set; } = null!;
        public virtual DbSet<Template> Templates { get; set; } = null!;
        public virtual DbSet<WorkTime> WorkTimes { get; set; } = null!;

        protected override void OnConfiguring(DbContextOptionsBuilder optionsBuilder)
        {
//            if (!optionsBuilder.IsConfigured)
//            {
//#warning To protect potentially sensitive information in your connection string, you should move it out of source code. You can avoid scaffolding the connection string by using the Name= syntax to read it from configuration - see https://go.microsoft.com/fwlink/?linkid=2131148. For more guidance on storing connection strings, see http://go.microsoft.com/fwlink/?LinkId=723263.
//                optionsBuilder.UseSqlServer("Server=SQL5111.site4now.net; Initial Catalog=db_a63a88_iprotech; User Id=db_a63a88_iprotech_admin;Password=B570@Com");
//            }
        }

        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {
            modelBuilder.Entity<Account>(entity =>
            {
                entity.Property(e => e.Email)
                    .HasMaxLength(50)
                    .HasColumnName("email");

                entity.Property(e => e.Image)
                    .HasMaxLength(250)
                    .HasColumnName("image");

                entity.Property(e => e.Mobileno)
                    .HasMaxLength(50)
                    .HasColumnName("mobileno");

                entity.Property(e => e.Name).HasMaxLength(250);

                entity.Property(e => e.Password)
                    .HasMaxLength(250)
                    .HasColumnName("password");

                entity.Property(e => e.ShortScrap)
                    .HasMaxLength(500)
                    .HasColumnName("shortScrap");

                entity.Property(e => e.Type).HasColumnName("type");

                entity.Property(e => e.UserId).HasMaxLength(450);

                entity.Property(e => e.Username)
                    .HasMaxLength(50)
                    .HasColumnName("username");

                entity.HasOne(d => d.User)
                    .WithMany(p => p.Accounts)
                    .HasForeignKey(d => d.UserId)
                    .HasConstraintName("FK_Accounts_AspNetUsers");
            });

            modelBuilder.Entity<Activity>(entity =>
            {
                entity.Property(e => e.Detail).HasMaxLength(500);

                entity.Property(e => e.Name).HasMaxLength(500);

                entity.Property(e => e.Type).HasColumnName("type");
            });

            modelBuilder.Entity<AspNetRole>(entity =>
            {
                entity.HasIndex(e => e.NormalizedName, "RoleNameIndex")
                    .IsUnique()
                    .HasFilter("([NormalizedName] IS NOT NULL)");

                entity.Property(e => e.Name).HasMaxLength(256);

                entity.Property(e => e.NormalizedName).HasMaxLength(256);
            });

            modelBuilder.Entity<AspNetRoleClaim>(entity =>
            {
                entity.HasIndex(e => e.RoleId, "IX_AspNetRoleClaims_RoleId");

                entity.HasOne(d => d.Role)
                    .WithMany(p => p.AspNetRoleClaims)
                    .HasForeignKey(d => d.RoleId);
            });

            modelBuilder.Entity<AspNetUser>(entity =>
            {
                entity.HasIndex(e => e.NormalizedEmail, "EmailIndex");

                entity.HasIndex(e => e.NormalizedUserName, "UserNameIndex")
                    .IsUnique()
                    .HasFilter("([NormalizedUserName] IS NOT NULL)");

                entity.Property(e => e.Email).HasMaxLength(256);

                entity.Property(e => e.FullName).HasMaxLength(250);

                entity.Property(e => e.Image).HasMaxLength(250);

                entity.Property(e => e.NormalizedEmail).HasMaxLength(256);

                entity.Property(e => e.NormalizedUserName).HasMaxLength(256);

                entity.Property(e => e.ShortScrap).HasMaxLength(500);

                entity.Property(e => e.State)
                    .HasMaxLength(1)
                    .HasColumnName("state")
                    .HasDefaultValueSql("('A')");

                entity.Property(e => e.UserName).HasMaxLength(256);

                entity.HasMany(d => d.Roles)
                    .WithMany(p => p.Users)
                    .UsingEntity<Dictionary<string, object>>(
                        "AspNetUserRole",
                        l => l.HasOne<AspNetRole>().WithMany().HasForeignKey("RoleId"),
                        r => r.HasOne<AspNetUser>().WithMany().HasForeignKey("UserId"),
                        j =>
                        {
                            j.HasKey("UserId", "RoleId");

                            j.ToTable("AspNetUserRoles");

                            j.HasIndex(new[] { "RoleId" }, "IX_AspNetUserRoles_RoleId");
                        });
            });

            modelBuilder.Entity<AspNetUserClaim>(entity =>
            {
                entity.HasIndex(e => e.UserId, "IX_AspNetUserClaims_UserId");

                entity.HasOne(d => d.User)
                    .WithMany(p => p.AspNetUserClaims)
                    .HasForeignKey(d => d.UserId);
            });

            modelBuilder.Entity<AspNetUserLogin>(entity =>
            {
                entity.HasKey(e => new { e.LoginProvider, e.ProviderKey });

                entity.HasIndex(e => e.UserId, "IX_AspNetUserLogins_UserId");

                entity.HasOne(d => d.User)
                    .WithMany(p => p.AspNetUserLogins)
                    .HasForeignKey(d => d.UserId);
            });

            modelBuilder.Entity<AspNetUserToken>(entity =>
            {
                entity.HasKey(e => new { e.UserId, e.LoginProvider, e.Name });

                entity.HasOne(d => d.User)
                    .WithMany(p => p.AspNetUserTokens)
                    .HasForeignKey(d => d.UserId);
            });

            modelBuilder.Entity<AuthorRight>(entity =>
            {
                entity.Property(e => e.Address).HasMaxLength(50);

                entity.Property(e => e.Authfile).HasMaxLength(100);

                entity.Property(e => e.Date).HasMaxLength(50);

                entity.Property(e => e.UserId).HasColumnName("User_Id");
            });

            modelBuilder.Entity<BusinessSecret>(entity =>
            {
                entity.ToTable("BusinessSecret");

                entity.Property(e => e.Details).HasMaxLength(250);

                entity.Property(e => e.Name).HasMaxLength(100);
            });

            modelBuilder.Entity<Card>(entity =>
            {
                entity.Property(e => e.CardNo).HasMaxLength(50);

                entity.Property(e => e.Csv)
                    .HasMaxLength(50)
                    .HasColumnName("csv");

                entity.Property(e => e.ExpireDate).HasMaxLength(50);

                entity.Property(e => e.Name).HasMaxLength(50);

                entity.Property(e => e.UserId).HasColumnName("User_Id");

                entity.Property(e => e.UserId1)
                    .HasMaxLength(450)
                    .HasColumnName("UserId");

                entity.HasOne(d => d.UserId1Navigation)
                    .WithMany(p => p.Cards)
                    .HasForeignKey(d => d.UserId1)
                    .HasConstraintName("FK_Cards_AspNetUsers");
            });

            modelBuilder.Entity<Class>(entity =>
            {
                entity.Property(e => e.ActiveId).HasColumnName("Active_Id");

                entity.Property(e => e.Name).HasMaxLength(50);
            });

            modelBuilder.Entity<Classification>(entity =>
            {
                entity.Property(e => e.Describe).HasMaxLength(500);

                entity.Property(e => e.Name).HasMaxLength(50);
            });

            modelBuilder.Entity<Consal>(entity =>
            {
                entity.Property(e => e.Name).HasMaxLength(250);

                entity.Property(e => e.Period)
                    .HasMaxLength(50)
                    .HasColumnName("period");
            });

            modelBuilder.Entity<ConsalConsaltant>(entity =>
            {
                entity.ToTable("Consal_Consaltants");

                entity.HasOne(d => d.ConsalNavigation)
                    .WithMany(p => p.ConsalConsaltants)
                    .HasForeignKey(d => d.Consal)
                    .HasConstraintName("FK_Consals_Consaltants_consals");

                entity.HasOne(d => d.ConsaltantNavigation)
                    .WithMany(p => p.ConsalConsaltants)
                    .HasForeignKey(d => d.Consaltant)
                    .HasConstraintName("FK_Consals_Consaltants_consaltants");
            });

            modelBuilder.Entity<Consaltant>(entity =>
            {
                entity.Property(e => e.AccountNo).HasMaxLength(50);

                entity.Property(e => e.ConsName).HasMaxLength(200);

                entity.Property(e => e.ConsScrap).HasMaxLength(250);

                entity.Property(e => e.ConsType).HasMaxLength(50);

                entity.Property(e => e.Email).HasMaxLength(50);

                entity.Property(e => e.IsNotary)
                    .IsRequired()
                    .HasDefaultValueSql("((1))");

                entity.Property(e => e.MobileNo).HasMaxLength(50);

                entity.Property(e => e.Password).HasMaxLength(50);

                entity.Property(e => e.UserId).HasMaxLength(450);

                entity.Property(e => e.UserName).HasMaxLength(50);

                entity.Property(e => e.WorkTime).HasMaxLength(250);

                entity.HasOne(d => d.Acount)
                    .WithMany(p => p.Consaltants)
                    .HasForeignKey(d => d.AcountId)
                    .OnDelete(DeleteBehavior.ClientSetNull)
                    .HasConstraintName("FK_Consaltants_Accounts");

                entity.HasOne(d => d.User)
                    .WithMany(p => p.Consaltants)
                    .HasForeignKey(d => d.UserId)
                    .HasConstraintName("FK_Consaltants_AspNetUsers");
            });

            modelBuilder.Entity<ConsaltantOrder>(entity =>
            {
                entity.ToTable("ConsaltantOrder");

                entity.Property(e => e.ConsTitle).HasMaxLength(250);

                entity.Property(e => e.Consfile)
                    .HasMaxLength(250)
                    .HasColumnName("consfile");

                entity.Property(e => e.Details).HasMaxLength(500);

                entity.Property(e => e.OrderDate)
                    .HasMaxLength(50)
                    .HasColumnName("orderDate");

                entity.Property(e => e.OrderTime)
                    .HasMaxLength(50)
                    .HasColumnName("orderTime");

                entity.Property(e => e.UserId).HasColumnName("User_Id");
            });

            modelBuilder.Entity<ConsaltantsRating>(entity =>
            {
                entity.ToTable("ConsaltantsRating");

                entity.Property(e => e.Comment).HasMaxLength(1000);

                entity.Property(e => e.RateDate).HasColumnType("date");

                entity.Property(e => e.UserId).HasMaxLength(450);

                entity.HasOne(d => d.Cons)
                    .WithMany(p => p.ConsaltantsRatings)
                    .HasForeignKey(d => d.ConsId)
                    .HasConstraintName("FK_ConsaltantsRating_Consaltants");

                entity.HasOne(d => d.User)
                    .WithMany(p => p.ConsaltantsRatings)
                    .HasForeignKey(d => d.UserId)
                    .OnDelete(DeleteBehavior.ClientSetNull)
                    .HasConstraintName("FK_ConsaltantsRating_AspNetUsers");
            });

            modelBuilder.Entity<ContactU>(entity =>
            {
                entity.Property(e => e.Email).HasMaxLength(20);

                entity.Property(e => e.IsRead).HasColumnName("isRead");

                entity.Property(e => e.IsReplay).HasColumnName("isReplay");

                entity.Property(e => e.Message).HasColumnName("message");

                entity.Property(e => e.Name).HasMaxLength(500);

                entity.Property(e => e.OrderDate).HasColumnType("datetime");

                entity.Property(e => e.PhoneNo)
                    .HasMaxLength(50)
                    .HasColumnName("phoneNo");

                entity.Property(e => e.Subject).HasMaxLength(250);
            });

            modelBuilder.Entity<Department>(entity =>
            {
                entity.Property(e => e.Name).HasMaxLength(50);
            });

            modelBuilder.Entity<Invention>(entity =>
            {
                entity.Property(e => e.Nmae).HasMaxLength(50);
            });

            modelBuilder.Entity<MarkRegister>(entity =>
            {
                entity.ToTable("MarkRegister");

                entity.Property(e => e.Marketfile)
                    .HasMaxLength(200)
                    .HasColumnName("marketfile");

                entity.Property(e => e.Notes).HasMaxLength(500);

                entity.Property(e => e.Type).HasMaxLength(50);

                entity.Property(e => e.UserId).HasColumnName("User_Id");

                entity.Property(e => e.UserId1)
                    .HasMaxLength(450)
                    .HasColumnName("UserId");

                entity.HasOne(d => d.UserId1Navigation)
                    .WithMany(p => p.MarkRegisters)
                    .HasForeignKey(d => d.UserId1)
                    .HasConstraintName("FK_MarkRegister_AspNetUsers");
            });

            modelBuilder.Entity<Model>(entity =>
            {
                entity.Property(e => e.Name).HasMaxLength(250);

                entity.Property(e => e.Type).HasMaxLength(250);
            });

            modelBuilder.Entity<ModelsQuestion>(entity =>
            {
                entity.HasOne(d => d.ModelNavigation)
                    .WithMany(p => p.ModelsQuestions)
                    .HasForeignKey(d => d.Model)
                    .HasConstraintName("FK_ModelsQuestions_Models1");
            });

            modelBuilder.Entity<MyContent>(entity =>
            {
                entity.ToTable("MyContent");

                entity.Property(e => e.IsActive).HasDefaultValueSql("((1))");
            });

            modelBuilder.Entity<MyCustomer>(entity =>
            {
                entity.ToTable("MyCustomer");

                entity.Property(e => e.IsActive).HasDefaultValueSql("((1))");

                entity.Property(e => e.Name).HasMaxLength(100);
            });

            modelBuilder.Entity<MyStore>(entity =>
            {
                entity.ToTable("MyStore");

                entity.Property(e => e.IsActive).HasDefaultValueSql("((1))");

                entity.Property(e => e.Name).HasMaxLength(100);
            });

            modelBuilder.Entity<MyType>(entity =>
            {
                entity.Property(e => e.Details).HasMaxLength(500);

                entity.Property(e => e.Type).HasColumnName("type");

                entity.Property(e => e.TypeName).HasMaxLength(50);

                entity.HasOne(d => d.ActiveNavigation)
                    .WithMany(p => p.MyTypes)
                    .HasForeignKey(d => d.Active)
                    .HasConstraintName("FK_Types_Activities1");
            });

            modelBuilder.Entity<News>(entity =>
            {
                entity.Property(e => e.Details).HasColumnName("details");

                entity.Property(e => e.Img)
                    .HasMaxLength(500)
                    .HasColumnName("img");

                entity.Property(e => e.Title)
                    .HasMaxLength(250)
                    .HasColumnName("title");

                entity.Property(e => e.Type).HasColumnName("type");
            });

            modelBuilder.Entity<Order>(entity =>
            {
                entity.Property(e => e.Accepted)
                    .IsRequired()
                    .HasDefaultValueSql("((1))");

                entity.Property(e => e.Address).HasMaxLength(50);

                entity.Property(e => e.Authfile).HasMaxLength(100);

                entity.Property(e => e.Charcter).HasMaxLength(500);

                entity.Property(e => e.ConsTitle).HasMaxLength(250);

                entity.Property(e => e.Consfile)
                    .HasMaxLength(250)
                    .HasColumnName("consfile");

                entity.Property(e => e.Date).HasMaxLength(50);

                entity.Property(e => e.Email)
                    .HasMaxLength(50)
                    .HasColumnName("email");

                entity.Property(e => e.ExpireDate).HasMaxLength(50);

                entity.Property(e => e.GovFeesAccount).HasMaxLength(100);

                entity.Property(e => e.GovFeesProcessNo).HasMaxLength(100);

                entity.Property(e => e.Idea).HasMaxLength(500);

                entity.Property(e => e.InvBackground).HasMaxLength(500);

                entity.Property(e => e.Invfile)
                    .HasMaxLength(250)
                    .HasColumnName("invfile");

                entity.Property(e => e.Marketfile)
                    .HasMaxLength(200)
                    .HasColumnName("marketfile");

                entity.Property(e => e.Name).HasMaxLength(150);

                entity.Property(e => e.Notes).HasMaxLength(500);

                entity.Property(e => e.OrderDate)
                    .HasMaxLength(50)
                    .HasColumnName("orderDate");

                entity.Property(e => e.OrderState)
                    .HasMaxLength(50)
                    .HasColumnName("orderState");

                entity.Property(e => e.OrderTime)
                    .HasMaxLength(50)
                    .HasColumnName("orderTime");

                entity.Property(e => e.OrderType)
                    .HasMaxLength(50)
                    .HasColumnName("orderType");

                entity.Property(e => e.Pay).HasColumnName("pay");

                entity.Property(e => e.Period)
                    .HasMaxLength(50)
                    .HasColumnName("period");

                entity.Property(e => e.Phone).HasMaxLength(50);

                entity.Property(e => e.ProposedValue)
                    .HasMaxLength(50)
                    .HasColumnName("proposedValue");

                entity.Property(e => e.SModel).HasColumnName("sModel");

                entity.Property(e => e.SecretFile)
                    .HasMaxLength(100)
                    .HasColumnName("secretFile");

                entity.Property(e => e.SecretScrap).HasMaxLength(500);

                entity.Property(e => e.SecurityElements).HasMaxLength(500);

                entity.Property(e => e.Summery).HasMaxLength(500);

                entity.Property(e => e.TechRecourse).HasColumnName("techRecourse");

                entity.Property(e => e.TechRecurseDescribe).HasColumnName("techRecurseDescribe");

                entity.Property(e => e.Title)
                    .HasMaxLength(250)
                    .HasColumnName("title");

                entity.Property(e => e.UserId).HasColumnName("User_Id");

                entity.Property(e => e.UserId1)
                    .HasMaxLength(450)
                    .HasColumnName("UserId");

                entity.HasOne(d => d.ActivityNavigation)
                    .WithMany(p => p.Orders)
                    .HasForeignKey(d => d.Activity)
                    .HasConstraintName("FK_Orders_Activityrelation");

                entity.HasOne(d => d.TypeNavigation)
                    .WithMany(p => p.Orders)
                    .HasForeignKey(d => d.Type)
                    .HasConstraintName("FK_Orders_MyTypes");

                entity.HasOne(d => d.UserId1Navigation)
                    .WithMany(p => p.Orders)
                    .HasForeignKey(d => d.UserId1)
                    .HasConstraintName("FK_Orders_AspNetUsers");
            });

            modelBuilder.Entity<OrderComplation>(entity =>
            {
                entity.ToTable("OrderComplation");

                entity.Property(e => e.Charcter).HasMaxLength(500);

                entity.Property(e => e.Describe).HasMaxLength(500);

                entity.Property(e => e.InvBackground).HasMaxLength(500);

                entity.Property(e => e.SecurityElements).HasMaxLength(500);

                entity.Property(e => e.Summery).HasMaxLength(500);

                entity.Property(e => e.UserId).HasColumnName("User_Id");

                entity.Property(e => e.UserId1)
                    .HasMaxLength(450)
                    .HasColumnName("UserId");

                entity.HasOne(d => d.UserId1Navigation)
                    .WithMany(p => p.OrderComplations)
                    .HasForeignKey(d => d.UserId1)
                    .HasConstraintName("FK_OrderComplation_AspNetUsers");
            });

            modelBuilder.Entity<OrdersFile>(entity =>
            {
                entity.Property(e => e.FType).HasColumnName("fType");

                entity.Property(e => e.FileLink).HasMaxLength(500);

                entity.Property(e => e.FileName).HasMaxLength(250);

                entity.HasOne(d => d.Order)
                    .WithMany(p => p.OrdersFiles)
                    .HasForeignKey(d => d.OrderId)
                    .OnDelete(DeleteBehavior.ClientSetNull)
                    .HasConstraintName("FK_Orders_OrdersFiles");
            });

            modelBuilder.Entity<OrdersModel>(entity =>
            {
                entity.ToTable("OrdersModel");

                entity.Property(e => e.ClauseType).HasMaxLength(50);

                entity.HasOne(d => d.Model)
                    .WithMany(p => p.OrdersModels)
                    .HasForeignKey(d => d.ModelId)
                    .HasConstraintName("FK_OrdersModel_Models");

                entity.HasOne(d => d.Order)
                    .WithMany(p => p.OrdersModels)
                    .HasForeignKey(d => d.OrderId)
                    .OnDelete(DeleteBehavior.ClientSetNull)
                    .HasConstraintName("FK_OrdersModel_Orders");
            });

            modelBuilder.Entity<Platform>(entity =>
            {
                entity.ToTable("Platform");

                entity.Property(e => e.Link).HasMaxLength(150);

                entity.Property(e => e.Name).HasMaxLength(100);

                entity.Property(e => e.SetLink)
                    .HasMaxLength(150)
                    .HasColumnName("setLink");
            });

            modelBuilder.Entity<PricingOreder>(entity =>
            {
                entity.Property(e => e.Details).HasMaxLength(500);

                entity.Property(e => e.Email).HasMaxLength(50);

                entity.Property(e => e.Name).HasMaxLength(500);

                entity.Property(e => e.OrderDate).HasColumnType("datetime");

                entity.Property(e => e.PhoneNumber).HasMaxLength(50);

                entity.Property(e => e.State)
                    .HasMaxLength(50)
                    .HasColumnName("state");
            });

            modelBuilder.Entity<Proc>(entity =>
            {
                entity.Property(e => e.ProcName).HasMaxLength(200);

                entity.Property(e => e.ProcTime).HasMaxLength(50);
            });

            modelBuilder.Entity<RegisterInvention>(entity =>
            {
                entity.ToTable("RegisterInvention");

                entity.Property(e => e.Details).UseCollation("Arabic_CI_AI_KS_WS");

                entity.Property(e => e.Invfile)
                    .HasMaxLength(250)
                    .HasColumnName("invfile")
                    .UseCollation("Arabic_CI_AI_KS_WS");

                entity.Property(e => e.Title)
                    .HasMaxLength(250)
                    .HasColumnName("title")
                    .UseCollation("Arabic_CI_AI_KS_WS");

                entity.Property(e => e.UserId).HasColumnName("User_Id");

                entity.Property(e => e.UserId1)
                    .HasMaxLength(450)
                    .HasColumnName("UserId");

                entity.HasOne(d => d.UserId1Navigation)
                    .WithMany(p => p.RegisterInventions)
                    .HasForeignKey(d => d.UserId1)
                    .HasConstraintName("FK_RegisterInvention_AspNetUsers");
            });

            modelBuilder.Entity<Relation>(entity =>
            {
                entity.Property(e => e.Details).HasMaxLength(500);

                entity.Property(e => e.Name).HasMaxLength(50);
            });

            modelBuilder.Entity<Reserve>(entity =>
            {
                entity.ToTable("Reserve");

                entity.Property(e => e.ReserveDate).HasColumnType("date");

                entity.Property(e => e.State).HasColumnName("state");

                entity.Property(e => e.UserId).HasMaxLength(450);

                entity.HasOne(d => d.User)
                    .WithMany(p => p.Reserves)
                    .HasForeignKey(d => d.UserId)
                    .OnDelete(DeleteBehavior.ClientSetNull)
                    .HasConstraintName("FK_Consaltant_AspNetUsers");
            });

            modelBuilder.Entity<SecretRegister>(entity =>
            {
                entity.ToTable("SecretRegister");

                entity.Property(e => e.Email)
                    .HasMaxLength(50)
                    .HasColumnName("email");

                entity.Property(e => e.ExpireDate).HasMaxLength(50);

                entity.Property(e => e.Name).HasMaxLength(150);

                entity.Property(e => e.Phone).HasMaxLength(50);

                entity.Property(e => e.Relation).HasMaxLength(250);

                entity.Property(e => e.SModel)
                    .HasMaxLength(50)
                    .HasColumnName("sModel");

                entity.Property(e => e.SecretFile)
                    .HasMaxLength(100)
                    .HasColumnName("secretFile");

                entity.Property(e => e.SecretScrap).HasMaxLength(500);

                entity.Property(e => e.SecretType).HasMaxLength(50);

                entity.Property(e => e.UserId).HasColumnName("User_Id");

                entity.Property(e => e.UserId1)
                    .HasMaxLength(450)
                    .HasColumnName("UserId");

                entity.HasOne(d => d.UserId1Navigation)
                    .WithMany(p => p.SecretRegisters)
                    .HasForeignKey(d => d.UserId1)
                    .HasConstraintName("FK_SecretRegister_AspNetUsers");
            });

            modelBuilder.Entity<Template>(entity =>
            {
                entity.Property(e => e.Characters).HasMaxLength(200);

                entity.Property(e => e.ClassId).HasColumnName("Class_Id");

                entity.Property(e => e.Name).HasMaxLength(50);

                entity.Property(e => e.TypeId).HasColumnName("Type_Id");
            });

            modelBuilder.Entity<WorkTime>(entity =>
            {
                entity.ToTable("WorkTime");

                entity.Property(e => e.Day).HasMaxLength(50);

                entity.Property(e => e.EndTime)
                    .HasMaxLength(50)
                    .HasColumnName("endTime");

                entity.Property(e => e.StartTime)
                    .HasMaxLength(50)
                    .HasColumnName("startTime");

                entity.HasOne(d => d.Cons)
                    .WithMany(p => p.WorkTimes)
                    .HasForeignKey(d => d.ConsId)
                    .HasConstraintName("FK_WorkTime_Consaltants");
            });

            OnModelCreatingPartial(modelBuilder);
        }

        partial void OnModelCreatingPartial(ModelBuilder modelBuilder);
    }
}
