﻿using System;
using System.Collections.Generic;

namespace PowerAccounting.Models2
{
    public partial class AspNetUser
    {
        public AspNetUser()
        {
            Accounts = new HashSet<Account>();
            AspNetUserClaims = new HashSet<AspNetUserClaim>();
            AspNetUserLogins = new HashSet<AspNetUserLogin>();
            AspNetUserTokens = new HashSet<AspNetUserToken>();
            Cards = new HashSet<Card>();
            Consaltants = new HashSet<Consaltant>();
            ConsaltantsRatings = new HashSet<ConsaltantsRating>();
            MarkRegisters = new HashSet<MarkRegister>();
            OrderComplations = new HashSet<OrderComplation>();
            Orders = new HashSet<Order>();
            RegisterInventions = new HashSet<RegisterInvention>();
            Reserves = new HashSet<Reserve>();
            SecretRegisters = new HashSet<SecretRegister>();
            Roles = new HashSet<AspNetRole>();
        }

        public string Id { get; set; } = null!;
        public string? RefreshToken { get; set; }
        public DateTime RefreshTokenExpiryTime { get; set; }
        public string? UserName { get; set; }
        public string? NormalizedUserName { get; set; }
        public string? Email { get; set; }
        public string? NormalizedEmail { get; set; }
        public bool EmailConfirmed { get; set; }
        public string? PasswordHash { get; set; }
        public string? SecurityStamp { get; set; }
        public string? ConcurrencyStamp { get; set; }
        public string? PhoneNumber { get; set; }
        public bool PhoneNumberConfirmed { get; set; }
        public bool TwoFactorEnabled { get; set; }
        public DateTimeOffset? LockoutEnd { get; set; }
        public bool LockoutEnabled { get; set; }
        public int AccessFailedCount { get; set; }
        public string? FullName { get; set; }
        public string? ShortScrap { get; set; }
        public string? Image { get; set; }
        public bool? Type { get; set; }
        public bool Deleted { get; set; }
        public string State { get; set; } = null!;

        public virtual ICollection<Account> Accounts { get; set; }
        public virtual ICollection<AspNetUserClaim> AspNetUserClaims { get; set; }
        public virtual ICollection<AspNetUserLogin> AspNetUserLogins { get; set; }
        public virtual ICollection<AspNetUserToken> AspNetUserTokens { get; set; }
        public virtual ICollection<Card> Cards { get; set; }
        public virtual ICollection<Consaltant> Consaltants { get; set; }
        public virtual ICollection<ConsaltantsRating> ConsaltantsRatings { get; set; }
        public virtual ICollection<MarkRegister> MarkRegisters { get; set; }
        public virtual ICollection<OrderComplation> OrderComplations { get; set; }
        public virtual ICollection<Order> Orders { get; set; }
        public virtual ICollection<RegisterInvention> RegisterInventions { get; set; }
        public virtual ICollection<Reserve> Reserves { get; set; }
        public virtual ICollection<SecretRegister> SecretRegisters { get; set; }

        public virtual ICollection<AspNetRole> Roles { get; set; }
    }
}
