﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using PowerAccounting.Models2;

namespace PowerAccounting.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class WorkTimesController : ControllerBase
    {
        private readonly db_a63a88_iprotechContext _context;

        public WorkTimesController(db_a63a88_iprotechContext context)
        {
            _context = context;
        }

        // GET: api/WorkTimes
        [HttpGet]
        public async Task<ActionResult<IEnumerable<WorkTime>>> GetWorkTimes()
        {
            return await _context.WorkTimes.ToListAsync();
        }

        // GET: api/WorkTimes/5
        [HttpGet("{id}")]
        public async Task<ActionResult<WorkTime>> GetWorkTime(int id)
        {
            var workTime = await _context.WorkTimes.FindAsync(id);

            if (workTime == null)
            {
                return NotFound();
            }

            return workTime;
        }

        // PUT: api/WorkTimes/5
        // To protect from overposting attacks, enable the specific properties you want to bind to, for
        // more details, see https://go.microsoft.com/fwlink/?linkid=2123754.
        [HttpPut("{id}")]
        public async Task<IActionResult> PutWorkTime(int id, WorkTime workTime)
        {
            if (id != workTime.Id)
            {
                return BadRequest();
            }

            _context.Entry(workTime).State = EntityState.Modified;

            try
            {
                await _context.SaveChangesAsync();
            }
            catch (DbUpdateConcurrencyException)
            {
                if (!WorkTimeExists(id))
                {
                    return NotFound();
                }
                else
                {
                    throw;
                }
            }

            return NoContent();
        }

        // POST: api/WorkTimes
        // To protect from overposting attacks, enable the specific properties you want to bind to, for
        // more details, see https://go.microsoft.com/fwlink/?linkid=2123754.
        [HttpPost]
        public async Task<ActionResult<WorkTime>> PostWorkTime(WorkTime workTime)
        {
            _context.WorkTimes.Add(workTime);
            await _context.SaveChangesAsync();

            return CreatedAtAction("GetWorkTime", new { id = workTime.Id }, workTime);
        }

        // DELETE: api/WorkTimes/5
        [HttpDelete("{id}")]
        public async Task<ActionResult<WorkTime>> DeleteWorkTime(int id)
        {
            var workTime = await _context.WorkTimes.FindAsync(id);
            if (workTime == null)
            {
                return NotFound();
            }

            _context.WorkTimes.Remove(workTime);
            await _context.SaveChangesAsync();

            return workTime;
        }

        private bool WorkTimeExists(int id)
        {
            return _context.WorkTimes.Any(e => e.Id == id);
        }
    }
}
