﻿using System;
using System.Collections.Generic;
using System.Data;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using PowerAccounting.Models;
using PowerAccounting.Service;


using Microsoft.AspNetCore.Mvc.RazorPages;
using Microsoft.Extensions.Logging;
using Microsoft.Reporting.NETCore;
using Webgentle.BookStore.Models;
using System.Drawing;
using System.Drawing.Imaging;
using PowerAccounting.Models2;
using Webgentle.BookStore.Repository;
//using SQLitePCL;

namespace PowerAccounting.Controllers
{
    //StartController
    [Route("MyReports")]
    [ApiController]
    public class ValuesTowController : ControllerBase
    {
        private readonly IAccountRepository _accountRepository;
        private readonly db_a63a88_iprotechContext _context;

//        ModelTypes:Array<any>=[
//    {id:"1",name:"جديد"},
//    {id:"2",name:"تحت الدراسة"},
//    { id: "3",name: "تحت الاجراء"},
//    { id: "4",name: "تحت التنفيذ"},
//    { id: "5",name: "تم التحويل"},
//    { id: "6",name: "تم التنفيذ"},
//    { id: "7",name: "مرفوض"},
//    { id: "8",name: "مغلق"}
//  ];

//ModelTypes2 =Array[
//    {id:"1",name:"سر تجاري"},
//    {id:"2",name:"حقوق مؤلف"},
//    { id: "3",name: "علامة تجارية"},
//    { id: "4",name: "براءة اختراع"},
//    { id: "5",name: "حقوق نشر"},
//    { id: "6",name: "طلب استشارة"},
//    { id: "7",name: "طلب عام"}
//  ];
        public  string path;
        public List<Class2> list;
        private IServiceReport IReport;
        public int AccNo;
        public string LocalParam5;
        public List<string> OrderState;
        public List<string> OrderType;
        public ValuesTowController(IAccountRepository accountRepository, IServiceReport iServiceReport, db_a63a88_iprotechContext context)
        {
            _accountRepository = accountRepository;
            _context = context;
            IReport = iServiceReport;
            Encoding.RegisterProvider(CodePagesEncodingProvider.Instance);
            this.list = new List<Class2>();
            this.AccNo = 1;
            this.LocalParam5 = "";
            this.OrderState = new List<string>();
            this.OrderType = new List<string>();
            this.OrderState.Add("جديد");
            this.OrderState.Add("تحت الدراسة");
            this.OrderState.Add("تحت الاجراء");
            this.OrderState.Add("تحت التنفيذ");
            this.OrderState.Add("تم التحويل");
            this.OrderState.Add("تم التنفيذ");
            this.OrderState.Add("مرفوض");
            this.OrderState.Add("مغلق");

            this.OrderType.Add("سر تجاري");
            this.OrderType.Add("حقوق مؤلف");
            this.OrderType.Add("علامة تجارية");
            this.OrderType.Add("براءة اختراع");
            this.OrderType.Add("حقوق نشر");
            this.OrderType.Add("طلب استشارة");
            this.OrderType.Add("طلب عام");
        }

        [HttpGet]
        [Route("RepAnyReport")] 
        public IActionResult RepAnyBarcode(string ADate,string ZDate,int A,int B,int C,int D,int E,int F,int G,int H,int Type)
        {
            this.path = "";
            this.path = Path.Combine(Directory.GetCurrentDirectory(), "Report", "RepAllOrders.rdlc");
            if (Type == 0)
            {
                this.LocalParam5 = "تقرير بجميع الطلبات";
            }
            else
            {
                this.LocalParam5 = "تقرير لطلب محدد";
                this.path = Path.Combine(Directory.GetCurrentDirectory(), "Report", "RepOneOrder.rdlc");
                //this.path = Path.Combine(Directory.GetCurrentDirectory(), "Report", "RepOneOrder-New-Copy.rdlc");
            }
            this.list = GetOrdersAsync(ADate,ZDate,A,B,C,D,E,F,G,H,Type);
            var byteRes = new byte[] { };
            byteRes = IReport.CreateReportFile(this.list, this.path, this.LocalParam5);
            // return File(byteRes, System.Net.Mime.MediaTypeNames.Application.Octet,  "ReportName.pdf");
            return File(byteRes, "Application/pdf");
        }

        private bool TestMySystemDate(string bitA, string bitZ, string docDat)
        {
          
            // string temp = ""+(((docDat.Split(' ')[0]).Split('-')[2]) +"-"+ ((docDat.Split(' ')[0]).Split('-')[1]) +"-"+ ((docDat.Split(' ')[0]).Split('-')[0]));
            var dateFrom = Convert.ToDateTime(docDat);
           
           // var dateFrom = Convert.ToDateTime(temp);
            var dateToA = Convert.ToDateTime(bitA);
            var dateToZ = Convert.ToDateTime(bitZ);
            var result = ((dateFrom >= dateToA) && (dateFrom <= dateToZ));
            return result;
        }

        public List<Class2> GetOrdersAsync(string ADate, string ZDate, int A, int B, int C, int D, int E, int F, int G, int H,int Type)
        {
            List<Class2> objOrderDetails = new List<Class2>() { };
            try
            {
                // var testType = ((Type == 0) ? true : false);
                // this._context.Orders.AsEnumerable().Where(row=> ((Type == 0) ? true : ((testType==true)?(row.IsGeneral == true): (row.IsGeneral != true))) &&((row.OrderState==A.ToString())|| (row.OrderState == B.ToString())|| (row.OrderState == C.ToString())|| (row.OrderState == D.ToString())|| (row.OrderState == E.ToString())|| (row.OrderState == F.ToString())|| (row.OrderState == G.ToString())|| (row.OrderState == H.ToString()))).ToList().ForEach(op =>
               // var MyList = this._context.Orders.AsEnumerable().Where(op => op.OrderDate != null).Where(row => (this.TestMySystemDate(ADate, ZDate, row.OrderDate)) && ((row.OrderState == A.ToString()) || (row.OrderState == B.ToString()) || (row.OrderState == C.ToString()) || (row.OrderState == D.ToString()) || (row.OrderState == E.ToString()) || (row.OrderState == F.ToString()) || (row.OrderState == G.ToString()) || (row.OrderState == H.ToString()))).ToList();
                var MyList = this._context.Orders.AsEnumerable().Where(op => op.OrderDate != null).Where(row => (true) && ((row.OrderState == A.ToString()) || (row.OrderState == B.ToString()) || (row.OrderState == C.ToString()) || (row.OrderState == D.ToString()) || (row.OrderState == E.ToString()) || (row.OrderState == F.ToString()) || (row.OrderState == G.ToString()) || (row.OrderState == H.ToString()))).ToList();
                if (Type != 0)
                {
                    MyList = MyList.Where(sum => ((sum.Id == Type) ? true : false)).ToList();
                }
                else
                {
                    MyList = MyList.Where(sum => ((sum.UserId1 != null) ? true : false)).ToList();
                }
        
                MyList.ForEach(op =>
              
                // this._context.Orders.ToList().ForEach(op =>
                {
                    var MyUser = this._context.AspNetUsers.Find(op.UserId1);
                   // var MyUser = await this._accountRepository.GetUserByIdAsync(op.UserId1);
                  //  var MyUser = await this._accountRepository.GetUserByIdAsync(((op.UserId1!=null)?op.UserId1:"123"));
                    objOrderDetails.Add(new Class2()
                    {
                        columnDataColumn1 = ""+(op.Id),
                        columnDataColumn2=""+(op.OrderType),
                        //columnDataColumn2 = "" + this.OrderType[(int.Parse(op.OrderType))],
                        columnDataColumn3 = "" + (op.Idea),
                      // columnDataColumn3=""+ADate+"|"+ZDate+"|"+A+"|"+B+"|"+C+"|"+D+"|"+E+"|"+F+"|"+G+"|"+H+"|"+Type,
                        columnDataColumn4 = "" + (op.OrderDate),
                        columnDataColumn5=""+(op.OrderState),
                        // columnDataColumn5 = "" + this.OrderState[(int.Parse(op.OrderState))],
                        columnDataColumn6=(op.UserId1!=null)?""+(MyUser.UserName) :"",
                        columnDataColumn7= (op.UserId1 != null) ? "" + (MyUser.PhoneNumber) : "",
                        //columnDataColumn6 = ("" + MyUser.UserName),
                        //columnDataColumn7 = ("" + MyUser.PhoneNumber),
                        columnDataColumn8=""+op.Name,
                        columnDataColumn9=""+op.Phone,
                        columnDataColumn10=""+op.GovFeesProcessNo,
                        columnDataColumn11=""+op.GovFeesAccount,
                        columnDataColumn12=""+op.ProposedValue,
                        columnDataColumn13=""+op.Idea,
                        columnDataColumn14=""+op.Details,
                        columnDataColumn15 = ""+op.Describe,
                        columnDataColumn16 = ""+op.FinalReport,
                        columnDataColumn17 = "",
                        columnDataColumn18 = "",
                        columnDataColumn19 = "",
                        columnDataColumn20 = ""
                    });;
                });
            }
            catch (Exception ex)
            {
                ex.ToString();
            }
            return objOrderDetails;
        }

        //public List<Class2> GetOrders()
        //{
        //    List<Class2> objOrderDetails = new List<Class2>() { };
        //    try
        //    {
        //        this._context.Orders.AsEnumerable().ToList().ForEach(op =>
        //        {
        //            objOrderDetails.Add(new Class2()
        //            {
        //                columnDataColumn1 = "",
        //                columnDataColumn2 = "",
        //                columnDataColumn3 = "",
        //                columnDataColumn4 = "",
        //                columnDataColumn5 = "",
        //                columnDataColumn6 = "",
        //                columnDataColumn7 = "",
        //                columnDataColumn8 = "",
        //                columnDataColumn9 = "",
        //                columnDataColumn10 = "",
        //                columnDataColumn11 = "",
        //                columnDataColumn12 = "",
        //                columnDataColumn13 = "",
        //                columnDataColumn14 = "",
        //                columnDataColumn15 = "",
        //                columnDataColumn16 = "",
        //                columnDataColumn17 = "",
        //                columnDataColumn18 = "",
        //                columnDataColumn19 = "",
        //                columnDataColumn20 = ""
        //            });
        //        });
        //    }
        //    catch (Exception ex)
        //    {
        //        ex.ToString();
        //    }
        //    return objOrderDetails;
        //}


    }

}

