﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using PowerAccounting.Models2;

namespace PowerAccounting.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class SecretRegistersController : ControllerBase
    {
        private readonly db_a63a88_iprotechContext _context;

        public SecretRegistersController(db_a63a88_iprotechContext context)
        {
            _context = context;
        }

        // GET: api/SecretRegisters
        [HttpGet]
        public async Task<ActionResult<IEnumerable<SecretRegister>>> GetSecretRegisters()
        {
            return await _context.SecretRegisters.ToListAsync();
        }

        // GET: api/SecretRegisters/5
        [HttpGet("{id}")]
        public async Task<ActionResult<SecretRegister>> GetSecretRegister(int id)
        {
            var secretRegister = await _context.SecretRegisters.FindAsync(id);

            if (secretRegister == null)
            {
                return NotFound();
            }

            return secretRegister;
        }

        // PUT: api/SecretRegisters/5
        // To protect from overposting attacks, enable the specific properties you want to bind to, for
        // more details, see https://go.microsoft.com/fwlink/?linkid=2123754.
        [HttpPut("{id}")]
        public async Task<IActionResult> PutSecretRegister(int id, SecretRegister secretRegister)
        {
            if (id != secretRegister.Id)
            {
                return BadRequest();
            }

            _context.Entry(secretRegister).State = EntityState.Modified;

            try
            {
                await _context.SaveChangesAsync();
            }
            catch (DbUpdateConcurrencyException)
            {
                if (!SecretRegisterExists(id))
                {
                    return NotFound();
                }
                else
                {
                    throw;
                }
            }

            return NoContent();
        }

        // POST: api/SecretRegisters
        // To protect from overposting attacks, enable the specific properties you want to bind to, for
        // more details, see https://go.microsoft.com/fwlink/?linkid=2123754.
        [HttpPost]
        public async Task<ActionResult<SecretRegister>> PostSecretRegister(SecretRegister secretRegister)
        {
            _context.SecretRegisters.Add(secretRegister);
            await _context.SaveChangesAsync();

            return CreatedAtAction("GetSecretRegister", new { id = secretRegister.Id }, secretRegister);
        }

        // DELETE: api/SecretRegisters/5
        [HttpDelete("{id}")]
        public async Task<ActionResult<SecretRegister>> DeleteSecretRegister(int id)
        {
            var secretRegister = await _context.SecretRegisters.FindAsync(id);
            if (secretRegister == null)
            {
                return NotFound();
            }

            _context.SecretRegisters.Remove(secretRegister);
            await _context.SaveChangesAsync();

            return secretRegister;
        }

        private bool SecretRegisterExists(int id)
        {
            return _context.SecretRegisters.Any(e => e.Id == id);
        }
    }
}
