﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using PowerAccounting.Models2;

namespace PowerAccounting.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class RegisterInventionsController : ControllerBase
    {
        private readonly db_a63a88_iprotechContext _context;

        public RegisterInventionsController(db_a63a88_iprotechContext context)
        {
            _context = context;
        }

        // GET: api/RegisterInventions
        [HttpGet]
        public async Task<ActionResult<IEnumerable<RegisterInvention>>> GetRegisterInventions()
        {
            return await _context.RegisterInventions.ToListAsync();
        }

        // GET: api/RegisterInventions/5
        [HttpGet("{id}")]
        public async Task<ActionResult<RegisterInvention>> GetRegisterInvention(int id)
        {
            var registerInvention = await _context.RegisterInventions.FindAsync(id);

            if (registerInvention == null)
            {
                return NotFound();
            }

            return registerInvention;
        }

        // PUT: api/RegisterInventions/5
        // To protect from overposting attacks, enable the specific properties you want to bind to, for
        // more details, see https://go.microsoft.com/fwlink/?linkid=2123754.
        [HttpPut("{id}")]
        public async Task<IActionResult> PutRegisterInvention(int id, RegisterInvention registerInvention)
        {
            if (id != registerInvention.Id)
            {
                return BadRequest();
            }

            _context.Entry(registerInvention).State = EntityState.Modified;

            try
            {
                await _context.SaveChangesAsync();
            }
            catch (DbUpdateConcurrencyException)
            {
                if (!RegisterInventionExists(id))
                {
                    return NotFound();
                }
                else
                {
                    throw;
                }
            }

            return NoContent();
        }

        // POST: api/RegisterInventions
        // To protect from overposting attacks, enable the specific properties you want to bind to, for
        // more details, see https://go.microsoft.com/fwlink/?linkid=2123754.
        [HttpPost]
        public async Task<ActionResult<RegisterInvention>> PostRegisterInvention(RegisterInvention registerInvention)
        {
            _context.RegisterInventions.Add(registerInvention);
            await _context.SaveChangesAsync();

            return CreatedAtAction("GetRegisterInvention", new { id = registerInvention.Id }, registerInvention);
        }

        // DELETE: api/RegisterInventions/5
        [HttpDelete("{id}")]
        public async Task<ActionResult<RegisterInvention>> DeleteRegisterInvention(int id)
        {
            var registerInvention = await _context.RegisterInventions.FindAsync(id);
            if (registerInvention == null)
            {
                return NotFound();
            }

            _context.RegisterInventions.Remove(registerInvention);
            await _context.SaveChangesAsync();

            return registerInvention;
        }

        private bool RegisterInventionExists(int id)
        {
            return _context.RegisterInventions.Any(e => e.Id == id);
        }
    }
}
