﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using PowerAccounting.Models2;

namespace PowerAccounting.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class ProcsController : ControllerBase
    {
        private readonly db_a63a88_iprotechContext _context;

        public ProcsController(db_a63a88_iprotechContext context)
        {
            _context = context;
        }

        // GET: api/Procs
        [HttpGet]
        public async Task<ActionResult<IEnumerable<Proc>>> GetProcs()
        {
            return await _context.Procs.ToListAsync();
        }

        // GET: api/Procs/5
        [HttpGet("{id}")]
        public async Task<ActionResult<Proc>> GetProc(int id)
        {
            var proc = await _context.Procs.FindAsync(id);

            if (proc == null)
            {
                return NotFound();
            }

            return proc;
        }

        // PUT: api/Procs/5
        // To protect from overposting attacks, enable the specific properties you want to bind to, for
        // more details, see https://go.microsoft.com/fwlink/?linkid=2123754.
        [HttpPut("{id}")]
        public async Task<IActionResult> PutProc(int id, Proc proc)
        {
            if (id != proc.Id)
            {
                return BadRequest();
            }

            _context.Entry(proc).State = EntityState.Modified;

            try
            {
                await _context.SaveChangesAsync();
            }
            catch (DbUpdateConcurrencyException)
            {
                if (!ProcExists(id))
                {
                    return NotFound();
                }
                else
                {
                    throw;
                }
            }

            return NoContent();
        }

        // POST: api/Procs
        // To protect from overposting attacks, enable the specific properties you want to bind to, for
        // more details, see https://go.microsoft.com/fwlink/?linkid=2123754.
        [HttpPost]
        public async Task<ActionResult<Proc>> PostProc(Proc proc)
        {
            _context.Procs.Add(proc);
            await _context.SaveChangesAsync();

            return CreatedAtAction("GetProc", new { id = proc.Id }, proc);
        }

        // DELETE: api/Procs/5
        [HttpDelete("{id}")]
        public async Task<ActionResult<Proc>> DeleteProc(int id)
        {
            var proc = await _context.Procs.FindAsync(id);
            if (proc == null)
            {
                return NotFound();
            }

            _context.Procs.Remove(proc);
            await _context.SaveChangesAsync();

            return proc;
        }

        private bool ProcExists(int id)
        {
            return _context.Procs.Any(e => e.Id == id);
        }
    }
}
