﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using PowerAccounting.Models2;

namespace PowerAccounting.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class PricingOredersController : ControllerBase
    {
        private readonly db_a63a88_iprotechContext _context;

        public PricingOredersController(db_a63a88_iprotechContext context)
        {
            _context = context;
        }

        // GET: api/PricingOreders
        [HttpGet]
        public async Task<ActionResult<IEnumerable<PricingOreder>>> GetPricingOreders()
        {
            return await _context.PricingOreders.ToListAsync();
        }

        // GET: api/PricingOreders/5
        [HttpGet("{id}")]
        public async Task<ActionResult<PricingOreder>> GetPricingOreder(long id)
        {
            var pricingOreder = await _context.PricingOreders.FindAsync(id);

            if (pricingOreder == null)
            {
                return NotFound();
            }

            return pricingOreder;
        }

        // PUT: api/PricingOreders/5
        // To protect from overposting attacks, enable the specific properties you want to bind to, for
        // more details, see https://go.microsoft.com/fwlink/?linkid=2123754.
        [HttpPut("{id}")]
        public async Task<IActionResult> PutPricingOreder(long id, PricingOreder pricingOreder)
        {
            if (id != pricingOreder.Id)
            {
                return BadRequest();
            }

            _context.Entry(pricingOreder).State = EntityState.Modified;

            try
            {
                await _context.SaveChangesAsync();
            }
            catch (DbUpdateConcurrencyException)
            {
                if (!PricingOrederExists(id))
                {
                    return NotFound();
                }
                else
                {
                    throw;
                }
            }

            return NoContent();
        }

        // POST: api/PricingOreders
        // To protect from overposting attacks, enable the specific properties you want to bind to, for
        // more details, see https://go.microsoft.com/fwlink/?linkid=2123754.
        [HttpPost]
        public async Task<ActionResult<PricingOreder>> PostPricingOreder(PricingOreder pricingOreder)
        {
            _context.PricingOreders.Add(pricingOreder);
            await _context.SaveChangesAsync();

            return CreatedAtAction("GetPricingOreder", new { id = pricingOreder.Id }, pricingOreder);
        }

        // DELETE: api/PricingOreders/5
        [HttpDelete("{id}")]
        public async Task<ActionResult<PricingOreder>> DeletePricingOreder(long id)
        {
            var pricingOreder = await _context.PricingOreders.FindAsync(id);
            if (pricingOreder == null)
            {
                return NotFound();
            }

            _context.PricingOreders.Remove(pricingOreder);
            await _context.SaveChangesAsync();

            return pricingOreder;
        }

        private bool PricingOrederExists(long id)
        {
            return _context.PricingOreders.Any(e => e.Id == id);
        }
    }
}
