﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using PowerAccounting.Models2;

namespace PowerAccounting.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class OrdersModelsController : ControllerBase
    {
        private readonly db_a63a88_iprotechContext _context;

        public OrdersModelsController(db_a63a88_iprotechContext context)
        {
            _context = context;
        }

        // GET: api/OrdersModels
        [HttpGet]
        public async Task<ActionResult<IEnumerable<OrdersModel>>> GetOrdersModels()
        {
            return await _context.OrdersModels.ToListAsync();
        }

        // GET: api/OrdersModels/5
        [HttpGet("{id}")]
        public async Task<ActionResult<OrdersModel>> GetOrdersModel(int id)
        {
            var ordersModel = await _context.OrdersModels.FindAsync(id);

            if (ordersModel == null)
            {
                return NotFound();
            }

            return ordersModel;
        }

        // PUT: api/OrdersModels/5
        // To protect from overposting attacks, enable the specific properties you want to bind to, for
        // more details, see https://go.microsoft.com/fwlink/?linkid=2123754.
        [HttpPut("{id}")]
        public async Task<IActionResult> PutOrdersModel(int id, OrdersModel ordersModel)
        {
            if (id != ordersModel.Id)
            {
                return BadRequest();
            }

            _context.Entry(ordersModel).State = EntityState.Modified;

            try
            {
                await _context.SaveChangesAsync();
            }
            catch (DbUpdateConcurrencyException)
            {
                if (!OrdersModelExists(id))
                {
                    return NotFound();
                }
                else
                {
                    throw;
                }
            }

            return NoContent();
        }

        // POST: api/OrdersModels
        // To protect from overposting attacks, enable the specific properties you want to bind to, for
        // more details, see https://go.microsoft.com/fwlink/?linkid=2123754.
        [HttpPost]
        public async Task<ActionResult<OrdersModel>> PostOrdersModel(OrdersModel ordersModel)
        {
            _context.OrdersModels.Add(ordersModel);
            await _context.SaveChangesAsync();

            return CreatedAtAction("GetOrdersModel", new { id = ordersModel.Id }, ordersModel);
        }

        // DELETE: api/OrdersModels/5
        [HttpDelete("{id}")]
        public async Task<ActionResult<OrdersModel>> DeleteOrdersModel(int id)
        {
            var ordersModel = await _context.OrdersModels.FindAsync(id);
            if (ordersModel == null)
            {
                return NotFound();
            }

            _context.OrdersModels.Remove(ordersModel);
            await _context.SaveChangesAsync();

            return ordersModel;
        }

        private bool OrdersModelExists(int id)
        {
            return _context.OrdersModels.Any(e => e.Id == id);
        }
    }
}
