﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using PowerAccounting.Models2;

namespace PowerAccounting.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class OrdersFilesController : ControllerBase
    {
        private readonly db_a63a88_iprotechContext _context;

        public OrdersFilesController(db_a63a88_iprotechContext context)
        {
            _context = context;
        }

        // GET: api/OrdersFiles
        [HttpGet]
        public async Task<ActionResult<IEnumerable<OrdersFile>>> GetOrdersFiles()
        {
            return await _context.OrdersFiles.ToListAsync();
        }

        // GET: api/OrdersFiles/5
        //[HttpGet("{id}")]
        //public async Task<ActionResult<OrdersFile>> GetOrdersFile(int id)
        //{
        //    var ordersFile = await _context.OrdersFiles.FindAsync(id);

        //    if (ordersFile == null)
        //    {
        //        return NotFound();
        //    }

        //    return ordersFile;
        //}

        // GET: api/OrdersFiles/5
        [HttpGet("{id}")]
        public async Task<ActionResult<List<OrdersFile>>> GetOrdersFile(int id)
        {
            var ordersFile =await  _context.OrdersFiles.TakeWhile(doc=>doc.OrderId==id).ToListAsync();

            if (ordersFile == null)
            {
                return NotFound();
            }

            return ordersFile;
        }

        // PUT: api/OrdersFiles/5
        // To protect from overposting attacks, enable the specific properties you want to bind to, for
        // more details, see https://go.microsoft.com/fwlink/?linkid=2123754.
        [HttpPut("{id}")]
        public async Task<IActionResult> PutOrdersFile(int id, OrdersFile ordersFile)
        {
            if (id != ordersFile.Id)
            {
                return BadRequest();
            }

            _context.Entry(ordersFile).State = EntityState.Modified;

            try
            {
                await _context.SaveChangesAsync();
            }
            catch (DbUpdateConcurrencyException)
            {
                if (!OrdersFileExists(id))
                {
                    return NotFound();
                }
                else
                {
                    throw;
                }
            }

            return NoContent();
        }

        // POST: api/OrdersFiles
        // To protect from overposting attacks, enable the specific properties you want to bind to, for
        // more details, see https://go.microsoft.com/fwlink/?linkid=2123754.
        [HttpPost]
        public async Task<ActionResult<OrdersFile>> PostOrdersFile(OrdersFile ordersFile)
        {
            _context.OrdersFiles.Add(ordersFile);
            await _context.SaveChangesAsync();

            return CreatedAtAction("GetOrdersFile", new { id = ordersFile.Id }, ordersFile);
        }

        // DELETE: api/OrdersFiles/5
        [HttpDelete("{id}")]
        public async Task<ActionResult<OrdersFile>> DeleteOrdersFile(int id)
        {
            var ordersFile = await _context.OrdersFiles.FindAsync(id);
            if (ordersFile == null)
            {
                return NotFound();
            }

            _context.OrdersFiles.Remove(ordersFile);
            await _context.SaveChangesAsync();

            return ordersFile;
        }

        private bool OrdersFileExists(int id)
        {
            return _context.OrdersFiles.Any(e => e.Id == id);
        }
    }
}
