﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using PowerAccounting.Models2;

namespace PowerAccounting.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class OrderComplationsController : ControllerBase
    {
        private readonly db_a63a88_iprotechContext _context;

        public OrderComplationsController(db_a63a88_iprotechContext context)
        {
            _context = context;
        }

        // GET: api/OrderComplations
        [HttpGet]
        public async Task<ActionResult<IEnumerable<OrderComplation>>> GetOrderComplations()
        {
            return await _context.OrderComplations.ToListAsync();
        }

        // GET: api/OrderComplations/5
        [HttpGet("{id}")]
        public async Task<ActionResult<OrderComplation>> GetOrderComplation(int id)
        {
            var orderComplation = await _context.OrderComplations.FindAsync(id);

            if (orderComplation == null)
            {
                return NotFound();
            }

            return orderComplation;
        }

        // PUT: api/OrderComplations/5
        // To protect from overposting attacks, enable the specific properties you want to bind to, for
        // more details, see https://go.microsoft.com/fwlink/?linkid=2123754.
        [HttpPut("{id}")]
        public async Task<IActionResult> PutOrderComplation(int id, OrderComplation orderComplation)
        {
            if (id != orderComplation.Id)
            {
                return BadRequest();
            }

            _context.Entry(orderComplation).State = EntityState.Modified;

            try
            {
                await _context.SaveChangesAsync();
            }
            catch (DbUpdateConcurrencyException)
            {
                if (!OrderComplationExists(id))
                {
                    return NotFound();
                }
                else
                {
                    throw;
                }
            }

            return NoContent();
        }

        // POST: api/OrderComplations
        // To protect from overposting attacks, enable the specific properties you want to bind to, for
        // more details, see https://go.microsoft.com/fwlink/?linkid=2123754.
        [HttpPost]
        public async Task<ActionResult<OrderComplation>> PostOrderComplation(OrderComplation orderComplation)
        {
            _context.OrderComplations.Add(orderComplation);
            await _context.SaveChangesAsync();

            return CreatedAtAction("GetOrderComplation", new { id = orderComplation.Id }, orderComplation);
        }

        // DELETE: api/OrderComplations/5
        [HttpDelete("{id}")]
        public async Task<ActionResult<OrderComplation>> DeleteOrderComplation(int id)
        {
            var orderComplation = await _context.OrderComplations.FindAsync(id);
            if (orderComplation == null)
            {
                return NotFound();
            }

            _context.OrderComplations.Remove(orderComplation);
            await _context.SaveChangesAsync();

            return orderComplation;
        }

        private bool OrderComplationExists(int id)
        {
            return _context.OrderComplations.Any(e => e.Id == id);
        }
    }
}
