﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using PowerAccounting.Models2;

namespace PowerAccounting.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class MyTypesController : ControllerBase
    {
        private readonly db_a63a88_iprotechContext _context;

        public MyTypesController(db_a63a88_iprotechContext context)
        {
            _context = context;
        }

        // GET: api/MyTypes
        [HttpGet]
        public async Task<ActionResult<IEnumerable<MyType>>> GetMyTypes()
        {
            return await _context.MyTypes.ToListAsync();
        }

        // GET: api/MyTypes/5
        [HttpGet("{id}")]
        public async Task<ActionResult<MyType>> GetMyType(int id)
        {
            var myType = await _context.MyTypes.FindAsync(id);

            if (myType == null)
            {
                return NotFound();
            }

            return myType;
        }

        // PUT: api/MyTypes/5
        // To protect from overposting attacks, enable the specific properties you want to bind to, for
        // more details, see https://go.microsoft.com/fwlink/?linkid=2123754.
        [HttpPut("{id}")]
        public async Task<IActionResult> PutMyType(int id, MyType myType)
        {
            if (id != myType.Id)
            {
                return BadRequest();
            }

            _context.Entry(myType).State = EntityState.Modified;

            try
            {
                await _context.SaveChangesAsync();
            }
            catch (DbUpdateConcurrencyException)
            {
                if (!MyTypeExists(id))
                {
                    return NotFound();
                }
                else
                {
                    throw;
                }
            }

            return NoContent();
        }

        // POST: api/MyTypes
        // To protect from overposting attacks, enable the specific properties you want to bind to, for
        // more details, see https://go.microsoft.com/fwlink/?linkid=2123754.
        [HttpPost]
        public async Task<ActionResult<MyType>> PostMyType(MyType myType)
        {
            _context.MyTypes.Add(myType);
            await _context.SaveChangesAsync();

            return CreatedAtAction("GetMyType", new { id = myType.Id }, myType);
        }

        // DELETE: api/MyTypes/5
        [HttpDelete("{id}")]
        public async Task<ActionResult<MyType>> DeleteMyType(int id)
        {
            var myType = await _context.MyTypes.FindAsync(id);
            if (myType == null)
            {
                return NotFound();
            }

            _context.MyTypes.Remove(myType);
            await _context.SaveChangesAsync();

            return myType;
        }

        private bool MyTypeExists(int id)
        {
            return _context.MyTypes.Any(e => e.Id == id);
        }
    }
}
