﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using PowerAccounting.Models2;

namespace PowerAccounting.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class MyStoresController : ControllerBase
    {
        private readonly db_a63a88_iprotechContext _context;

        public MyStoresController(db_a63a88_iprotechContext context)
        {
            _context = context;
        }

        // GET: api/MyStores
        [HttpGet]
        public async Task<ActionResult<IEnumerable<MyStore>>> GetMyStores()
        {
            return await _context.MyStores.ToListAsync();
        }

        // GET: api/MyStores/5
        [HttpGet("{id}")]
        public async Task<ActionResult<MyStore>> GetMyStore(int id)
        {
            var myStore = await _context.MyStores.FindAsync(id);

            if (myStore == null)
            {
                return NotFound();
            }

            return myStore;
        }

        // PUT: api/MyStores/5
        // To protect from overposting attacks, enable the specific properties you want to bind to, for
        // more details, see https://go.microsoft.com/fwlink/?linkid=2123754.
        [HttpPut("{id}")]
        public async Task<IActionResult> PutMyStore(int id, MyStore myStore)
        {
            if (id != myStore.Id)
            {
                return BadRequest();
            }

            _context.Entry(myStore).State = EntityState.Modified;

            try
            {
                await _context.SaveChangesAsync();
            }
            catch (DbUpdateConcurrencyException)
            {
                if (!MyStoreExists(id))
                {
                    return NotFound();
                }
                else
                {
                    throw;
                }
            }

            return NoContent();
        }

        // POST: api/MyStores
        // To protect from overposting attacks, enable the specific properties you want to bind to, for
        // more details, see https://go.microsoft.com/fwlink/?linkid=2123754.
        [HttpPost]
        public async Task<ActionResult<MyStore>> PostMyStore(MyStore myStore)
        {
            _context.MyStores.Add(myStore);
            await _context.SaveChangesAsync();

            return CreatedAtAction("GetMyStore", new { id = myStore.Id }, myStore);
        }

        // DELETE: api/MyStores/5
        [HttpDelete("{id}")]
        public async Task<ActionResult<MyStore>> DeleteMyStore(int id)
        {
            var myStore = await _context.MyStores.FindAsync(id);
            if (myStore == null)
            {
                return NotFound();
            }

            _context.MyStores.Remove(myStore);
            await _context.SaveChangesAsync();

            return myStore;
        }

        private bool MyStoreExists(int id)
        {
            return _context.MyStores.Any(e => e.Id == id);
        }
    }
}
