﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using PowerAccounting.Models2;

namespace PowerAccounting.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class MyCustomersController : ControllerBase
    {
        private readonly db_a63a88_iprotechContext _context;

        public MyCustomersController(db_a63a88_iprotechContext context)
        {
            _context = context;
        }

        // GET: api/MyCustomers
        [HttpGet]
        public async Task<ActionResult<IEnumerable<MyCustomer>>> GetMyCustomers()
        {
            return await _context.MyCustomers.ToListAsync();
        }

        // GET: api/MyCustomers/5
        [HttpGet("{id}")]
        public async Task<ActionResult<MyCustomer>> GetMyCustomer(int id)
        {
            var myCustomer = await _context.MyCustomers.FindAsync(id);

            if (myCustomer == null)
            {
                return NotFound();
            }

            return myCustomer;
        }

        // PUT: api/MyCustomers/5
        // To protect from overposting attacks, enable the specific properties you want to bind to, for
        // more details, see https://go.microsoft.com/fwlink/?linkid=2123754.
        [HttpPut("{id}")]
        public async Task<IActionResult> PutMyCustomer(int id, MyCustomer myCustomer)
        {
            if (id != myCustomer.Id)
            {
                return BadRequest();
            }

            _context.Entry(myCustomer).State = EntityState.Modified;

            try
            {
                await _context.SaveChangesAsync();
            }
            catch (DbUpdateConcurrencyException)
            {
                if (!MyCustomerExists(id))
                {
                    return NotFound();
                }
                else
                {
                    throw;
                }
            }

            return NoContent();
        }

        // POST: api/MyCustomers
        // To protect from overposting attacks, enable the specific properties you want to bind to, for
        // more details, see https://go.microsoft.com/fwlink/?linkid=2123754.
        [HttpPost]
        public async Task<ActionResult<MyCustomer>> PostMyCustomer(MyCustomer myCustomer)
        {
            _context.MyCustomers.Add(myCustomer);
            await _context.SaveChangesAsync();

            return CreatedAtAction("GetMyCustomer", new { id = myCustomer.Id }, myCustomer);
        }

        // DELETE: api/MyCustomers/5
        [HttpDelete("{id}")]
        public async Task<ActionResult<MyCustomer>> DeleteMyCustomer(int id)
        {
            var myCustomer = await _context.MyCustomers.FindAsync(id);
            if (myCustomer == null)
            {
                return NotFound();
            }

            _context.MyCustomers.Remove(myCustomer);
            await _context.SaveChangesAsync();

            return myCustomer;
        }

        private bool MyCustomerExists(int id)
        {
            return _context.MyCustomers.Any(e => e.Id == id);
        }
    }
}
