﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using PowerAccounting.Models2;

namespace PowerAccounting.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class MyContentsController : ControllerBase
    {
        private readonly db_a63a88_iprotechContext _context;

        public MyContentsController(db_a63a88_iprotechContext context)
        {
            _context = context;
        }

        // GET: api/MyContents
        [HttpGet]
        public async Task<ActionResult<IEnumerable<MyContent>>> GetMyContents()
        {
            return await _context.MyContents.ToListAsync();
        }

        // GET: api/MyContents/5
        [HttpGet("{id}")]
        public async Task<ActionResult<MyContent>> GetMyContent(int id)
        {
            var myContent = await _context.MyContents.FindAsync(id);

            if (myContent == null)
            {
                return NotFound();
            }

            return myContent;
        }

        // PUT: api/MyContents/5
        // To protect from overposting attacks, enable the specific properties you want to bind to, for
        // more details, see https://go.microsoft.com/fwlink/?linkid=2123754.
        [HttpPut("{id}")]
        public async Task<IActionResult> PutMyContent(int id, MyContent myContent)
        {
            if (id != myContent.Id)
            {
                return BadRequest();
            }

            _context.Entry(myContent).State = EntityState.Modified;

            try
            {
                await _context.SaveChangesAsync();
            }
            catch (DbUpdateConcurrencyException)
            {
                if (!MyContentExists(id))
                {
                    return NotFound();
                }
                else
                {
                    throw;
                }
            }

            return NoContent();
        }

        // POST: api/MyContents
        // To protect from overposting attacks, enable the specific properties you want to bind to, for
        // more details, see https://go.microsoft.com/fwlink/?linkid=2123754.
        [HttpPost]
        public async Task<ActionResult<MyContent>> PostMyContent(MyContent myContent)
        {
            _context.MyContents.Add(myContent);
            await _context.SaveChangesAsync();

            return CreatedAtAction("GetMyContent", new { id = myContent.Id }, myContent);
        }

        // DELETE: api/MyContents/5
        [HttpDelete("{id}")]
        public async Task<ActionResult<MyContent>> DeleteMyContent(int id)
        {
            var myContent = await _context.MyContents.FindAsync(id);
            if (myContent == null)
            {
                return NotFound();
            }

            _context.MyContents.Remove(myContent);
            await _context.SaveChangesAsync();

            return myContent;
        }

        private bool MyContentExists(int id)
        {
            return _context.MyContents.Any(e => e.Id == id);
        }
    }
}
