﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using PowerAccounting.Models2;

namespace PowerAccounting.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class ModelsQuestionsController : ControllerBase
    {
        private readonly db_a63a88_iprotechContext _context;

        public ModelsQuestionsController(db_a63a88_iprotechContext context)
        {
            _context = context;
        }

        // GET: api/ModelsQuestions
        [HttpGet]
        public async Task<ActionResult<IEnumerable<ModelsQuestion>>> GetModelsQuestions()
        {
            return await _context.ModelsQuestions.ToListAsync();
        }

        // GET: api/ModelsQuestions/5
        [HttpGet("{id}")]
        public async Task<ActionResult<ModelsQuestion>> GetModelsQuestion(int id)
        {
            var modelsQuestion = await _context.ModelsQuestions.FindAsync(id);

            if (modelsQuestion == null)
            {
                return NotFound();
            }

            return modelsQuestion;
        }

        // PUT: api/ModelsQuestions/5
        // To protect from overposting attacks, enable the specific properties you want to bind to, for
        // more details, see https://go.microsoft.com/fwlink/?linkid=2123754.
        [HttpPut("{id}")]
        public async Task<IActionResult> PutModelsQuestion(int id, ModelsQuestion modelsQuestion)
        {
            if (id != modelsQuestion.Id)
            {
                return BadRequest();
            }

            _context.Entry(modelsQuestion).State = EntityState.Modified;

            try
            {
                await _context.SaveChangesAsync();
            }
            catch (DbUpdateConcurrencyException)
            {
                if (!ModelsQuestionExists(id))
                {
                    return NotFound();
                }
                else
                {
                    throw;
                }
            }

            return NoContent();
        }

        // POST: api/ModelsQuestions
        // To protect from overposting attacks, enable the specific properties you want to bind to, for
        // more details, see https://go.microsoft.com/fwlink/?linkid=2123754.
        [HttpPost]
        public async Task<ActionResult<ModelsQuestion>> PostModelsQuestion(ModelsQuestion modelsQuestion)
        {
            _context.ModelsQuestions.Add(modelsQuestion);
            await _context.SaveChangesAsync();

            return CreatedAtAction("GetModelsQuestion", new { id = modelsQuestion.Id }, modelsQuestion);
        }

        // DELETE: api/ModelsQuestions/5
        [HttpDelete("{id}")]
        public async Task<ActionResult<ModelsQuestion>> DeleteModelsQuestion(int id)
        {
            var modelsQuestion = await _context.ModelsQuestions.FindAsync(id);
            if (modelsQuestion == null)
            {
                return NotFound();
            }

            _context.ModelsQuestions.Remove(modelsQuestion);
            await _context.SaveChangesAsync();

            return modelsQuestion;
        }

        private bool ModelsQuestionExists(int id)
        {
            return _context.ModelsQuestions.Any(e => e.Id == id);
        }
    }
}
