﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using PowerAccounting.Models2;

namespace PowerAccounting.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class MarkRegistersController : ControllerBase
    {
        private readonly db_a63a88_iprotechContext _context;

        public MarkRegistersController(db_a63a88_iprotechContext context)
        {
            _context = context;
        }

        // GET: api/MarkRegisters
        [HttpGet]
        public async Task<ActionResult<IEnumerable<MarkRegister>>> GetMarkRegisters()
        {
            return await _context.MarkRegisters.ToListAsync();
        }

        // GET: api/MarkRegisters/5
        [HttpGet("{id}")]
        public async Task<ActionResult<MarkRegister>> GetMarkRegister(int id)
        {
            var markRegister = await _context.MarkRegisters.FindAsync(id);

            if (markRegister == null)
            {
                return NotFound();
            }

            return markRegister;
        }

        // PUT: api/MarkRegisters/5
        // To protect from overposting attacks, enable the specific properties you want to bind to, for
        // more details, see https://go.microsoft.com/fwlink/?linkid=2123754.
        [HttpPut("{id}")]
        public async Task<IActionResult> PutMarkRegister(int id, MarkRegister markRegister)
        {
            if (id != markRegister.Id)
            {
                return BadRequest();
            }

            _context.Entry(markRegister).State = EntityState.Modified;

            try
            {
                await _context.SaveChangesAsync();
            }
            catch (DbUpdateConcurrencyException)
            {
                if (!MarkRegisterExists(id))
                {
                    return NotFound();
                }
                else
                {
                    throw;
                }
            }

            return NoContent();
        }

        // POST: api/MarkRegisters
        // To protect from overposting attacks, enable the specific properties you want to bind to, for
        // more details, see https://go.microsoft.com/fwlink/?linkid=2123754.
        [HttpPost]
        public async Task<ActionResult<MarkRegister>> PostMarkRegister(MarkRegister markRegister)
        {
            _context.MarkRegisters.Add(markRegister);
            await _context.SaveChangesAsync();

            return CreatedAtAction("GetMarkRegister", new { id = markRegister.Id }, markRegister);
        }

        // DELETE: api/MarkRegisters/5
        [HttpDelete("{id}")]
        public async Task<ActionResult<MarkRegister>> DeleteMarkRegister(int id)
        {
            var markRegister = await _context.MarkRegisters.FindAsync(id);
            if (markRegister == null)
            {
                return NotFound();
            }

            _context.MarkRegisters.Remove(markRegister);
            await _context.SaveChangesAsync();

            return markRegister;
        }

        private bool MarkRegisterExists(int id)
        {
            return _context.MarkRegisters.Any(e => e.Id == id);
        }
    }
}
