﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using PowerAccounting.Models2;

namespace PowerAccounting.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class InventionsController : ControllerBase
    {
        private readonly db_a63a88_iprotechContext _context;

        public InventionsController(db_a63a88_iprotechContext context)
        {
            _context = context;
        }

        // GET: api/Inventions
        [HttpGet]
        public async Task<ActionResult<IEnumerable<Invention>>> GetInventions()
        {
            return await _context.Inventions.ToListAsync();
        }

        // GET: api/Inventions/5
        [HttpGet("{id}")]
        public async Task<ActionResult<Invention>> GetInvention(int id)
        {
            var invention = await _context.Inventions.FindAsync(id);

            if (invention == null)
            {
                return NotFound();
            }

            return invention;
        }

        // PUT: api/Inventions/5
        // To protect from overposting attacks, enable the specific properties you want to bind to, for
        // more details, see https://go.microsoft.com/fwlink/?linkid=2123754.
        [HttpPut("{id}")]
        public async Task<IActionResult> PutInvention(int id, Invention invention)
        {
            if (id != invention.Id)
            {
                return BadRequest();
            }

            _context.Entry(invention).State = EntityState.Modified;

            try
            {
                await _context.SaveChangesAsync();
            }
            catch (DbUpdateConcurrencyException)
            {
                if (!InventionExists(id))
                {
                    return NotFound();
                }
                else
                {
                    throw;
                }
            }

            return NoContent();
        }

        // POST: api/Inventions
        // To protect from overposting attacks, enable the specific properties you want to bind to, for
        // more details, see https://go.microsoft.com/fwlink/?linkid=2123754.
        [HttpPost]
        public async Task<ActionResult<Invention>> PostInvention(Invention invention)
        {
            _context.Inventions.Add(invention);
            await _context.SaveChangesAsync();

            return CreatedAtAction("GetInvention", new { id = invention.Id }, invention);
        }

        // DELETE: api/Inventions/5
        [HttpDelete("{id}")]
        public async Task<ActionResult<Invention>> DeleteInvention(int id)
        {
            var invention = await _context.Inventions.FindAsync(id);
            if (invention == null)
            {
                return NotFound();
            }

            _context.Inventions.Remove(invention);
            await _context.SaveChangesAsync();

            return invention;
        }

        private bool InventionExists(int id)
        {
            return _context.Inventions.Any(e => e.Id == id);
        }
    }
}
