﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using PowerAccounting.Models2;

namespace PowerAccounting.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class GovernmentsFeesController : ControllerBase
    {
        private readonly db_a63a88_iprotechContext _context;

        public GovernmentsFeesController(db_a63a88_iprotechContext context)
        {
            _context = context;
        }

        // GET: api/GovernmentsFees
        [HttpGet]
        public async Task<ActionResult<IEnumerable<GovernmentsFee>>> GetGovernmentsFees()
        {
            return await _context.GovernmentsFees.ToListAsync();
        }

        // GET: api/GovernmentsFees/5
        [HttpGet("{id}")]
        public async Task<ActionResult<GovernmentsFee>> GetGovernmentsFee(int id)
        {
            var governmentsFee = await _context.GovernmentsFees.FindAsync(id);

            if (governmentsFee == null)
            {
                return NotFound();
            }

            return governmentsFee;
        }

        // PUT: api/GovernmentsFees/5
        // To protect from overposting attacks, enable the specific properties you want to bind to, for
        // more details, see https://go.microsoft.com/fwlink/?linkid=2123754.
        [HttpPut("{id}")]
        public async Task<IActionResult> PutGovernmentsFee(int id, GovernmentsFee governmentsFee)
        {
            if (id != governmentsFee.Id)
            {
                return BadRequest();
            }

            _context.Entry(governmentsFee).State = EntityState.Modified;

            try
            {
                await _context.SaveChangesAsync();
            }
            catch (DbUpdateConcurrencyException)
            {
                if (!GovernmentsFeeExists(id))
                {
                    return NotFound();
                }
                else
                {
                    throw;
                }
            }

            return NoContent();
        }

        // POST: api/GovernmentsFees
        // To protect from overposting attacks, enable the specific properties you want to bind to, for
        // more details, see https://go.microsoft.com/fwlink/?linkid=2123754.
        [HttpPost]
        public async Task<ActionResult<GovernmentsFee>> PostGovernmentsFee(GovernmentsFee governmentsFee)
        {
            _context.GovernmentsFees.Add(governmentsFee);
            await _context.SaveChangesAsync();

            return CreatedAtAction("GetGovernmentsFee", new { id = governmentsFee.Id }, governmentsFee);
        }

        // DELETE: api/GovernmentsFees/5
        [HttpDelete("{id}")]
        public async Task<ActionResult<GovernmentsFee>> DeleteGovernmentsFee(int id)
        {
            var governmentsFee = await _context.GovernmentsFees.FindAsync(id);
            if (governmentsFee == null)
            {
                return NotFound();
            }

            _context.GovernmentsFees.Remove(governmentsFee);
            await _context.SaveChangesAsync();

            return governmentsFee;
        }

        private bool GovernmentsFeeExists(int id)
        {
            return _context.GovernmentsFees.Any(e => e.Id == id);
        }
    }
}
