﻿using IPROTECHWEBSITE.Util;
using Microsoft.AspNetCore.Identity;
using Microsoft.AspNetCore.Mvc;
using PowerAccounting.Areas.Identity.Data;
using PowerAccounting.Models2;
using System.Threading.Tasks;
using System;
using System.Collections.Generic;

// For more information on enabling Web API for empty projects, visit https://go.microsoft.com/fwlink/?LinkID=397860

namespace PowerAccounting.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class DeleteMyAccountController : ControllerBase
    {
        private readonly UserManager<PowerAccountingUser> _userManager;
        private readonly db_a63a88_iprotechContext _context;
        public DeleteMyAccountController(db_a63a88_iprotechContext _context, UserManager<PowerAccountingUser> _userManager)
        {
            this._context = _context;
            this._userManager = _userManager;
        }

        // GET: api/<DeleteMyAccountController>
        [HttpGet]
        public IEnumerable<string> Get()
        {
            return new string[] { "value1", "value2" };
        }

        // GET api/<DeleteMyAccountController>/5
        [HttpGet("{id}")]
        public async Task<IActionResult> Get(string id)
        {
            try
            {
                if (id == null) 
                {
                    return Ok(new { State = 1, Id = "", PhoneNumber = "", FullName = "مستخدم غير موجود" });
                }
                ValidateToken token = new ValidateToken();
                (bool, string) res = token.validate(id, _context);
                if (res.Item1 == false) 
                {
                    return Ok(new { State = 2, Id = "", PhoneNumber = "", FullName = res.Item2 });
                }
                var data = await _userManager.FindByIdAsync(res.Item2);
                if (data == null) 
                {
                    return Ok(new { State = 3, Id = "", PhoneNumber = "", FullName = "مستخدم غير موجود" });
                }

                return Ok(new { state = 4, Id = data.Id, phoneNumber = data.PhoneNumber, fullName = data.FullName });
            }
            catch (Exception ex)
            {
                return Ok(new { state = 0, message = "خطاء اثناء التاكد من وجود الحساب", exception = ex });
            }
        }

        // POST api/<DeleteMyAccountController>
        [HttpPost]
       // public async Task<IActionResult> ConfirmDeleteMyAccount([FromBody] string Id)
        public async Task<IActionResult> Post([FromBody] string Id)
        {
            try
            {
                var user = await _userManager.FindByIdAsync(Id);
                if (user == null) return Ok(new { state = 1, message = "خطاء اثناء الحذف" });
                user.Deleted = true;
                await _userManager.UpdateAsync(user);
                await _userManager.RemoveAuthenticationTokenAsync(user, "Api", "ApiToken");
                return Ok(new { state = 4, message = "تم الحذف بنجاح" });
            }
            catch (Exception ex)
            {
                return Ok(new { state = 0, message = "خطاء اثناء الحذف" ,exception=ex});
            }
        }
        // PUT api/<DeleteMyAccountController>/5
        [HttpPut("{id}")]
        public void Put(int id, [FromBody] string value)
        {
        }

        // DELETE api/<DeleteMyAccountController>/5
        [HttpDelete("{id}")]
        public async Task<IActionResult> Delete(string id)
        {
            try
            {
                var user = await _userManager.FindByIdAsync(id);
                if (user == null) return Ok(new { state = 1, message = "خطاء اثناء الحذف" });
                user.Deleted = true;
                await _userManager.UpdateAsync(user);
                await _userManager.RemoveAuthenticationTokenAsync(user, "Api", "ApiToken");
                return Ok(new { state = 4, message = "تم الحذف بنجاح" });
            }
            catch (Exception ex)
            {
                return Ok(new { state = 0, message = "خطاء اثناء الحذف", exception = ex });
            }
        }
    }
}
