﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using PowerAccounting.Models2;

namespace PowerAccounting.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class ConsaltantsRatingsController : ControllerBase
    {
        private readonly db_a63a88_iprotechContext _context;

        public ConsaltantsRatingsController(db_a63a88_iprotechContext context)
        {
            _context = context;
        }

        // GET: api/ConsaltantsRatings
        [HttpGet]
        public async Task<ActionResult<IEnumerable<ConsaltantsRating>>> GetConsaltantsRatings()
        {
            return await _context.ConsaltantsRatings.ToListAsync();
        }

        // GET: api/ConsaltantsRatings/5
        [HttpGet("{id}")]
        public async Task<ActionResult<ConsaltantsRating>> GetConsaltantsRating(int id)
        {
            var consaltantsRating = await _context.ConsaltantsRatings.FindAsync(id);

            if (consaltantsRating == null)
            {
                return NotFound();
            }

            return consaltantsRating;
        }

        // PUT: api/ConsaltantsRatings/5
        // To protect from overposting attacks, enable the specific properties you want to bind to, for
        // more details, see https://go.microsoft.com/fwlink/?linkid=2123754.
        [HttpPut("{id}")]
        public async Task<IActionResult> PutConsaltantsRating(int id, ConsaltantsRating consaltantsRating)
        {
            if (id != consaltantsRating.Id)
            {
                return BadRequest();
            }

            _context.Entry(consaltantsRating).State = EntityState.Modified;

            try
            {
                await _context.SaveChangesAsync();
            }
            catch (DbUpdateConcurrencyException)
            {
                if (!ConsaltantsRatingExists(id))
                {
                    return NotFound();
                }
                else
                {
                    throw;
                }
            }

            return NoContent();
        }

        // POST: api/ConsaltantsRatings
        // To protect from overposting attacks, enable the specific properties you want to bind to, for
        // more details, see https://go.microsoft.com/fwlink/?linkid=2123754.
        [HttpPost]
        public async Task<ActionResult<ConsaltantsRating>> PostConsaltantsRating(ConsaltantsRating consaltantsRating)
        {
            _context.ConsaltantsRatings.Add(consaltantsRating);
            await _context.SaveChangesAsync();

            return CreatedAtAction("GetConsaltantsRating", new { id = consaltantsRating.Id }, consaltantsRating);
        }

        // DELETE: api/ConsaltantsRatings/5
        [HttpDelete("{id}")]
        public async Task<ActionResult<ConsaltantsRating>> DeleteConsaltantsRating(int id)
        {
            var consaltantsRating = await _context.ConsaltantsRatings.FindAsync(id);
            if (consaltantsRating == null)
            {
                return NotFound();
            }

            _context.ConsaltantsRatings.Remove(consaltantsRating);
            await _context.SaveChangesAsync();

            return consaltantsRating;
        }

        private bool ConsaltantsRatingExists(int id)
        {
            return _context.ConsaltantsRatings.Any(e => e.Id == id);
        }
    }
}
