﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using PowerAccounting.Models2;

namespace PowerAccounting.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class ConsaltantsController : ControllerBase
    {
        private readonly db_a63a88_iprotechContext _context;

        public ConsaltantsController(db_a63a88_iprotechContext context)
        {
            _context = context;
        }

        // GET: api/Consaltants
        [HttpGet]
        public async Task<ActionResult<IEnumerable<Consaltant>>> GetConsaltants()
        {
            return await _context.Consaltants.ToListAsync();
        }

        // GET: api/Consaltants/5
        [HttpGet("{id}")]
        public async Task<ActionResult<Consaltant>> GetConsaltant(int id)
        {
            var consaltant = await _context.Consaltants.FindAsync(id);

            if (consaltant == null)
            {
                return NotFound();
            }

            return consaltant;
        }

        // PUT: api/Consaltants/5
        // To protect from overposting attacks, enable the specific properties you want to bind to, for
        // more details, see https://go.microsoft.com/fwlink/?linkid=2123754.
        [HttpPut("{id}")]
        public async Task<IActionResult> PutConsaltant(int id, Consaltant consaltant)
        {
            if (id != consaltant.Id)
            {
                return BadRequest();
            }

            _context.Entry(consaltant).State = EntityState.Modified;

            try
            {
                await _context.SaveChangesAsync();
            }
            catch (DbUpdateConcurrencyException)
            {
                if (!ConsaltantExists(id))
                {
                    return NotFound();
                }
                else
                {
                    throw;
                }
            }

            return NoContent();
        }

        // POST: api/Consaltants
        // To protect from overposting attacks, enable the specific properties you want to bind to, for
        // more details, see https://go.microsoft.com/fwlink/?linkid=2123754.
        [HttpPost]
        public async Task<ActionResult<Consaltant>> PostConsaltant(Consaltant consaltant)
        {
            _context.Consaltants.Add(consaltant);
            await _context.SaveChangesAsync();

            return CreatedAtAction("GetConsaltant", new { id = consaltant.Id }, consaltant);
        }

        // DELETE: api/Consaltants/5
        [HttpDelete("{id}")]
        public async Task<ActionResult<Consaltant>> DeleteConsaltant(int id)
        {
            var consaltant = await _context.Consaltants.FindAsync(id);
            if (consaltant == null)
            {
                return NotFound();
            }
            else
            {
                var allLinks = _context.ConsalConsaltants.Where(op => op.Consaltant == id);
                _context.ConsalConsaltants.RemoveRange(allLinks);
                await _context.SaveChangesAsync();

                _context.Consaltants.Remove(consaltant);
                await _context.SaveChangesAsync();
            }


            return consaltant;
        }

        private bool ConsaltantExists(int id)
        {
            return _context.Consaltants.Any(e => e.Id == id);
        }
    }
}
