﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using PowerAccounting.Models2;

namespace PowerAccounting.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class ConsaltantOrdersController : ControllerBase
    {
        private readonly db_a63a88_iprotechContext _context;

        public ConsaltantOrdersController(db_a63a88_iprotechContext context)
        {
            _context = context;
        }

        // GET: api/ConsaltantOrders
        [HttpGet]
        public async Task<ActionResult<IEnumerable<ConsaltantOrder>>> GetConsaltantOrders()
        {
            return await _context.ConsaltantOrders.ToListAsync();
        }

        // GET: api/ConsaltantOrders/5
        [HttpGet("{id}")]
        public async Task<ActionResult<ConsaltantOrder>> GetConsaltantOrder(int id)
        {
            var consaltantOrder = await _context.ConsaltantOrders.FindAsync(id);

            if (consaltantOrder == null)
            {
                return NotFound();
            }

            return consaltantOrder;
        }

        // PUT: api/ConsaltantOrders/5
        // To protect from overposting attacks, enable the specific properties you want to bind to, for
        // more details, see https://go.microsoft.com/fwlink/?linkid=2123754.
        [HttpPut("{id}")]
        public async Task<IActionResult> PutConsaltantOrder(int id, ConsaltantOrder consaltantOrder)
        {
            if (id != consaltantOrder.Id)
            {
                return BadRequest();
            }

            _context.Entry(consaltantOrder).State = EntityState.Modified;

            try
            {
                await _context.SaveChangesAsync();
            }
            catch (DbUpdateConcurrencyException)
            {
                if (!ConsaltantOrderExists(id))
                {
                    return NotFound();
                }
                else
                {
                    throw;
                }
            }

            return NoContent();
        }

        // POST: api/ConsaltantOrders
        // To protect from overposting attacks, enable the specific properties you want to bind to, for
        // more details, see https://go.microsoft.com/fwlink/?linkid=2123754.
        [HttpPost]
        public async Task<ActionResult<ConsaltantOrder>> PostConsaltantOrder(ConsaltantOrder consaltantOrder)
        {
            _context.ConsaltantOrders.Add(consaltantOrder);
            await _context.SaveChangesAsync();

            return CreatedAtAction("GetConsaltantOrder", new { id = consaltantOrder.Id }, consaltantOrder);
        }

        // DELETE: api/ConsaltantOrders/5
        [HttpDelete("{id}")]
        public async Task<ActionResult<ConsaltantOrder>> DeleteConsaltantOrder(int id)
        {
            var consaltantOrder = await _context.ConsaltantOrders.FindAsync(id);
            if (consaltantOrder == null)
            {
                return NotFound();
            }

            _context.ConsaltantOrders.Remove(consaltantOrder);
            await _context.SaveChangesAsync();

            return consaltantOrder;
        }

        private bool ConsaltantOrderExists(int id)
        {
            return _context.ConsaltantOrders.Any(e => e.Id == id);
        }
    }
}
