﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using PowerAccounting.Models2;

namespace PowerAccounting.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class ConsalsController : ControllerBase
    {
        private readonly db_a63a88_iprotechContext _context;

        public ConsalsController(db_a63a88_iprotechContext context)
        {
            _context = context;
        }

        // GET: api/Consals
        [HttpGet]
        public async Task<ActionResult<IEnumerable<Consal>>> GetConsals()
        {
            return await _context.Consals.ToListAsync();
        }

        // GET: api/Consals/5
        [HttpGet("{id}")]
        public async Task<ActionResult<Consal>> GetConsal(int id)
        {
            var consal = await _context.Consals.FindAsync(id);

            if (consal == null)
            {
                return NotFound();
            }

            return consal;
        }

        // PUT: api/Consals/5
        // To protect from overposting attacks, enable the specific properties you want to bind to, for
        // more details, see https://go.microsoft.com/fwlink/?linkid=2123754.
        [HttpPut("{id}")]
        public async Task<IActionResult> PutConsal(int id, Consal consal)
        {
            if (id != consal.Id)
            {
                return BadRequest();
            }

            _context.Entry(consal).State = EntityState.Modified;

            try
            {
                await _context.SaveChangesAsync();
            }
            catch (DbUpdateConcurrencyException)
            {
                if (!ConsalExists(id))
                {
                    return NotFound();
                }
                else
                {
                    throw;
                }
            }

            return NoContent();
        }

        // POST: api/Consals
        // To protect from overposting attacks, enable the specific properties you want to bind to, for
        // more details, see https://go.microsoft.com/fwlink/?linkid=2123754.
        [HttpPost]
        public async Task<ActionResult<Consal>> PostConsal(Consal consal)
        {
            _context.Consals.Add(consal);
            await _context.SaveChangesAsync();

            return CreatedAtAction("GetConsal", new { id = consal.Id }, consal);
        }

        // DELETE: api/Consals/5
        [HttpDelete("{id}")]
        public async Task<ActionResult<Consal>> DeleteConsal(int id)
        {
            var consal = await _context.Consals.FindAsync(id);
            if (consal == null)
            {
                return NotFound();
            }

            _context.Consals.Remove(consal);
            await _context.SaveChangesAsync();

            return consal;
        }

        private bool ConsalExists(int id)
        {
            return _context.Consals.Any(e => e.Id == id);
        }
    }
}
