﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using PowerAccounting.Models2;

namespace PowerAccounting.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class ConsalConsaltantsController : ControllerBase
    {
        private readonly db_a63a88_iprotechContext _context;

        public ConsalConsaltantsController(db_a63a88_iprotechContext context)
        {
            _context = context;
        }

        // GET: api/ConsalConsaltants
        [HttpGet]
        public async Task<ActionResult<IEnumerable<ConsalConsaltant>>> GetConsalConsaltants()
        {
            return await _context.ConsalConsaltants.ToListAsync();
        }

        // GET: api/ConsalConsaltants/5
        [HttpGet("{id}")]
        public async Task<ActionResult<ConsalConsaltant>> GetConsalConsaltant(int id)
        {
            var consalConsaltant = await _context.ConsalConsaltants.FindAsync(id);

            if (consalConsaltant == null)
            {
                return NotFound();
            }

            return consalConsaltant;
        }

        // PUT: api/ConsalConsaltants/5
        // To protect from overposting attacks, enable the specific properties you want to bind to, for
        // more details, see https://go.microsoft.com/fwlink/?linkid=2123754.
        [HttpPut("{id}")]
        public async Task<IActionResult> PutConsalConsaltant(int id, ConsalConsaltant consalConsaltant)
        {
            if (id != consalConsaltant.Id)
            {
                return BadRequest();
            }

            _context.Entry(consalConsaltant).State = EntityState.Modified;

            try
            {
                await _context.SaveChangesAsync();
            }
            catch (DbUpdateConcurrencyException)
            {
                if (!ConsalConsaltantExists(id))
                {
                    return NotFound();
                }
                else
                {
                    throw;
                }
            }

            return NoContent();
        }

        // POST: api/ConsalConsaltants
        // To protect from overposting attacks, enable the specific properties you want to bind to, for
        // more details, see https://go.microsoft.com/fwlink/?linkid=2123754.
        [HttpPost]
        public async Task<ActionResult<ConsalConsaltant[]>> PostConsalConsaltant(Consal[] consalConsaltant)
        {
            List<ConsalConsaltant> tempList = new List<ConsalConsaltant> { };
            var test = _context.ConsalConsaltants.Where(op => op.Consaltant == consalConsaltant[0].Consaltant);
            if (test != null)
            {
                foreach (var item in test)
                {
                    _context.ConsalConsaltants.Remove(item);
                    await _context.SaveChangesAsync();
                }
             //   _context.ConsalConsaltants.RemoveRange(test);
               // await _context.SaveChangesAsync();
            }
            foreach (var item in consalConsaltant)
            {
                var temp = new ConsalConsaltant { Consal = item.Id, Consaltant = item.Consaltant };             
                tempList.Add(temp);
                await _context.ConsalConsaltants.AddAsync(temp);
                await _context.SaveChangesAsync();
            }
                  
            return CreatedAtAction("GetConsalConsaltant",new { id =tempList[0].Id}, tempList);
        }
        //[HttpPost]
        //public async Task<ActionResult<ConsalConsaltant>> PostConsalConsaltant(ConsalConsaltant consalConsaltant)
        //{
        //    _context.ConsalConsaltants.Add(consalConsaltant);
        //    await _context.SaveChangesAsync();

        //    return CreatedAtAction("GetConsalConsaltant", new { id = consalConsaltant.Id }, consalConsaltant);
        //}


        // DELETE: api/ConsalConsaltants/5
        [HttpDelete("{id}")]
        public async Task<ActionResult<ConsalConsaltant>> DeleteConsalConsaltant(int id)
        {
            var consalConsaltant = await _context.ConsalConsaltants.FindAsync(id);
            if (consalConsaltant == null)
            {
                return NotFound();
            }

            _context.ConsalConsaltants.Remove(consalConsaltant);
            await _context.SaveChangesAsync();

            return consalConsaltant;
        }

        private bool ConsalConsaltantExists(int id)
        {
            return _context.ConsalConsaltants.Any(e => e.Id == id);
        }
    }
}
