﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using PowerAccounting.Models2;

namespace PowerAccounting.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class BusinessSecretsController : ControllerBase
    {
        private readonly db_a63a88_iprotechContext _context;

        public BusinessSecretsController(db_a63a88_iprotechContext context)
        {
            _context = context;
        }

        // GET: api/BusinessSecrets
        [HttpGet]
        public async Task<ActionResult<IEnumerable<BusinessSecret>>> GetBusinessSecrets()
        {
            return await _context.BusinessSecrets.ToListAsync();
        }

        // GET: api/BusinessSecrets/5
        [HttpGet("{id}")]
        public async Task<ActionResult<BusinessSecret>> GetBusinessSecret(int id)
        {
            var businessSecret = await _context.BusinessSecrets.FindAsync(id);

            if (businessSecret == null)
            {
                return NotFound();
            }

            return businessSecret;
        }

        // PUT: api/BusinessSecrets/5
        // To protect from overposting attacks, enable the specific properties you want to bind to, for
        // more details, see https://go.microsoft.com/fwlink/?linkid=2123754.
        [HttpPut("{id}")]
        public async Task<IActionResult> PutBusinessSecret(int id, BusinessSecret businessSecret)
        {
            if (id != businessSecret.Id)
            {
                return BadRequest();
            }

            _context.Entry(businessSecret).State = EntityState.Modified;

            try
            {
                await _context.SaveChangesAsync();
            }
            catch (DbUpdateConcurrencyException)
            {
                if (!BusinessSecretExists(id))
                {
                    return NotFound();
                }
                else
                {
                    throw;
                }
            }

            return NoContent();
        }

        // POST: api/BusinessSecrets
        // To protect from overposting attacks, enable the specific properties you want to bind to, for
        // more details, see https://go.microsoft.com/fwlink/?linkid=2123754.
        [HttpPost]
        public async Task<ActionResult<BusinessSecret>> PostBusinessSecret(BusinessSecret businessSecret)
        {
            _context.BusinessSecrets.Add(businessSecret);
            await _context.SaveChangesAsync();

            return CreatedAtAction("GetBusinessSecret", new { id = businessSecret.Id }, businessSecret);
        }

        // DELETE: api/BusinessSecrets/5
        [HttpDelete("{id}")]
        public async Task<ActionResult<BusinessSecret>> DeleteBusinessSecret(int id)
        {
            var businessSecret = await _context.BusinessSecrets.FindAsync(id);
            if (businessSecret == null)
            {
                return NotFound();
            }

            _context.BusinessSecrets.Remove(businessSecret);
            await _context.SaveChangesAsync();

            return businessSecret;
        }

        private bool BusinessSecretExists(int id)
        {
            return _context.BusinessSecrets.Any(e => e.Id == id);
        }
    }
}
