﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using PowerAccounting.Models2;

namespace PowerAccounting.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class AuthorRightsController : ControllerBase
    {
        private readonly db_a63a88_iprotechContext _context;

        public AuthorRightsController(db_a63a88_iprotechContext context)
        {
            _context = context;
        }

        // GET: api/AuthorRights
        [HttpGet]
        public async Task<ActionResult<IEnumerable<AuthorRight>>> GetAuthorRights()
        {
            return await _context.AuthorRights.ToListAsync();
        }

        // GET: api/AuthorRights/5
        [HttpGet("{id}")]
        public async Task<ActionResult<AuthorRight>> GetAuthorRight(int id)
        {
            var authorRight = await _context.AuthorRights.FindAsync(id);

            if (authorRight == null)
            {
                return NotFound();
            }

            return authorRight;
        }

        // PUT: api/AuthorRights/5
        // To protect from overposting attacks, enable the specific properties you want to bind to, for
        // more details, see https://go.microsoft.com/fwlink/?linkid=2123754.
        [HttpPut("{id}")]
        public async Task<IActionResult> PutAuthorRight(int id, AuthorRight authorRight)
        {
            if (id != authorRight.Id)
            {
                return BadRequest();
            }

            _context.Entry(authorRight).State = EntityState.Modified;

            try
            {
                await _context.SaveChangesAsync();
            }
            catch (DbUpdateConcurrencyException)
            {
                if (!AuthorRightExists(id))
                {
                    return NotFound();
                }
                else
                {
                    throw;
                }
            }

            return NoContent();
        }

        // POST: api/AuthorRights
        // To protect from overposting attacks, enable the specific properties you want to bind to, for
        // more details, see https://go.microsoft.com/fwlink/?linkid=2123754.
        [HttpPost]
        public async Task<ActionResult<AuthorRight>> PostAuthorRight(AuthorRight authorRight)
        {
            _context.AuthorRights.Add(authorRight);
            await _context.SaveChangesAsync();

            return CreatedAtAction("GetAuthorRight", new { id = authorRight.Id }, authorRight);
        }

        // DELETE: api/AuthorRights/5
        [HttpDelete("{id}")]
        public async Task<ActionResult<AuthorRight>> DeleteAuthorRight(int id)
        {
            var authorRight = await _context.AuthorRights.FindAsync(id);
            if (authorRight == null)
            {
                return NotFound();
            }

            _context.AuthorRights.Remove(authorRight);
            await _context.SaveChangesAsync();

            return authorRight;
        }

        private bool AuthorRightExists(int id)
        {
            return _context.AuthorRights.Any(e => e.Id == id);
        }
    }
}
